/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.HashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3419;
import noppes.npcs.api.entity.data.INPCAdvanced;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Lines;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobBuilder;
import noppes.npcs.roles.JobChunkLoader;
import noppes.npcs.roles.JobConversation;
import noppes.npcs.roles.JobFarmer;
import noppes.npcs.roles.JobFollower;
import noppes.npcs.roles.JobGuard;
import noppes.npcs.roles.JobHealer;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.JobItemGiver;
import noppes.npcs.roles.JobPuppet;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleBank;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleDialog;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.roles.RolePostman;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.util.ValueUtil;

public class DataAdvanced
implements INPCAdvanced {
    public Lines interactLines = new Lines();
    public Lines worldLines = new Lines();
    public Lines attackLines = new Lines();
    public Lines killedLines = new Lines();
    public Lines killLines = new Lines();
    public Lines npcInteractLines = new Lines();
    public boolean orderedLines = false;
    private String idleSound = "";
    private String angrySound = "";
    private String hurtSound = "minecraft:entity.player.hurt";
    private String deathSound = "minecraft:entity.player.hurt";
    private String stepSound = "";
    private EntityNPCInterface npc;
    public FactionOptions factions = new FactionOptions();
    public boolean attackOtherFactions = false;
    public boolean defendFaction = false;
    public boolean disablePitch = false;
    public DataScenes scenes;

    public DataAdvanced(EntityNPCInterface npc) {
        this.npc = npc;
        this.scenes = new DataScenes(npc);
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10566("NpcLines", (class_2520)this.worldLines.save());
        compound.method_10566("NpcKilledLines", (class_2520)this.killedLines.save());
        compound.method_10566("NpcInteractLines", (class_2520)this.interactLines.save());
        compound.method_10566("NpcAttackLines", (class_2520)this.attackLines.save());
        compound.method_10566("NpcKillLines", (class_2520)this.killLines.save());
        compound.method_10566("NpcInteractNPCLines", (class_2520)this.npcInteractLines.save());
        compound.method_10556("OrderedLines", this.orderedLines);
        compound.method_10582("NpcIdleSound", this.idleSound);
        compound.method_10582("NpcAngrySound", this.angrySound);
        compound.method_10582("NpcHurtSound", this.hurtSound);
        compound.method_10582("NpcDeathSound", this.deathSound);
        compound.method_10582("NpcStepSound", this.stepSound);
        compound.method_10569("FactionID", this.npc.getFaction().id);
        compound.method_10556("AttackOtherFactions", this.attackOtherFactions);
        compound.method_10556("DefendFaction", this.defendFaction);
        compound.method_10556("DisablePitch", this.disablePitch);
        compound.method_10569("Role", this.npc.role.getType());
        compound.method_10569("NpcJob", this.npc.job.getType());
        compound.method_10566("FactionPoints", (class_2520)this.factions.save(new class_2487()));
        compound.method_10566("NPCDialogOptions", (class_2520)this.nbtDialogs(this.npc.dialogs));
        compound.method_10566("NpcScenes", (class_2520)this.scenes.save(new class_2487()));
        return compound;
    }

    public void readToNBT(class_2487 compound) {
        this.interactLines.readNBT(compound.method_10562("NpcInteractLines"));
        this.worldLines.readNBT(compound.method_10562("NpcLines"));
        this.attackLines.readNBT(compound.method_10562("NpcAttackLines"));
        this.killedLines.readNBT(compound.method_10562("NpcKilledLines"));
        this.killLines.readNBT(compound.method_10562("NpcKillLines"));
        this.npcInteractLines.readNBT(compound.method_10562("NpcInteractNPCLines"));
        this.orderedLines = compound.method_10577("OrderedLines");
        this.idleSound = compound.method_10558("NpcIdleSound");
        this.angrySound = compound.method_10558("NpcAngrySound");
        this.hurtSound = compound.method_10558("NpcHurtSound");
        this.deathSound = compound.method_10558("NpcDeathSound");
        this.stepSound = compound.method_10558("NpcStepSound");
        this.npc.setFaction(compound.method_10550("FactionID"));
        this.npc.faction = this.npc.getFaction();
        this.attackOtherFactions = compound.method_10577("AttackOtherFactions");
        this.defendFaction = compound.method_10577("DefendFaction");
        this.disablePitch = compound.method_10577("DisablePitch");
        this.setRole(compound.method_10550("Role"));
        this.setJob(compound.method_10550("NpcJob"));
        this.factions.load(compound.method_10562("FactionPoints"));
        this.npc.dialogs = this.getDialogs(compound.method_10554("NPCDialogOptions", 10));
        this.scenes.load(compound.method_10562("NpcScenes"));
    }

    private HashMap<Integer, DialogOption> getDialogs(class_2499 tagList) {
        HashMap<Integer, DialogOption> map = new HashMap<Integer, DialogOption>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 nbttagcompound = tagList.method_10602(i);
            int slot = nbttagcompound.method_10550("DialogSlot");
            DialogOption option = new DialogOption();
            option.readNBT(nbttagcompound.method_10562("NPCDialog"));
            option.optionType = 1;
            map.put(slot, option);
        }
        return map;
    }

    private class_2499 nbtDialogs(HashMap<Integer, DialogOption> dialogs2) {
        class_2499 nbttaglist = new class_2499();
        for (int slot : dialogs2.keySet()) {
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10569("DialogSlot", slot);
            nbttagcompound.method_10566("NPCDialog", (class_2520)dialogs2.get(slot).writeNBT());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    private Lines getLines(int type) {
        if (type == 0) {
            return this.interactLines;
        }
        if (type == 1) {
            return this.attackLines;
        }
        if (type == 2) {
            return this.worldLines;
        }
        if (type == 3) {
            return this.killedLines;
        }
        if (type == 4) {
            return this.killLines;
        }
        if (type == 5) {
            return this.npcInteractLines;
        }
        return null;
    }

    @Override
    public void setLine(int type, int slot, String text, String sound) {
        slot = ValueUtil.CorrectInt(slot, 0, 7);
        Lines lines = this.getLines(type);
        if (text == null || text.isEmpty()) {
            lines.lines.remove(slot);
        } else {
            Line line = lines.lines.get(slot);
            if (line == null) {
                line = new Line();
                lines.lines.put(slot, line);
            }
            line.setText(text);
            line.setSound(sound);
        }
    }

    @Override
    public String getLine(int type, int slot) {
        Line line = this.getLines((int)type).lines.get(slot);
        if (line == null) {
            return "";
        }
        return line.getText();
    }

    @Override
    public int getLineCount(int type) {
        return this.getLines((int)type).lines.size();
    }

    @Override
    public String getSound(int type) {
        String sound = null;
        if (type == 0) {
            sound = this.idleSound;
        } else if (type == 1) {
            sound = this.angrySound;
        } else if (type == 2) {
            sound = this.hurtSound;
        } else if (type == 3) {
            sound = this.deathSound;
        } else if (type == 4) {
            sound = this.stepSound;
        }
        if (sound != null && sound.isEmpty()) {
            return null;
        }
        return NoppesStringUtils.cleanResource(sound);
    }

    public void playSound(int type, float volume, float pitch) {
        String sound = this.getSound(type);
        if (sound == null) {
            return;
        }
        class_2338 pos = this.npc.method_24515();
        if (!this.npc.method_37908().field_9236) {
            Packets.sendNearby(this.npc.method_37908(), pos, 16, new PacketPlaySound(sound, pos, volume, pitch));
        } else {
            MusicController.Instance.playSound(class_3419.field_15246, sound, pos, volume, pitch);
        }
    }

    @Override
    public void setSound(int type, String sound) {
        if (sound == null) {
            sound = "";
        }
        sound = NoppesStringUtils.cleanResource(sound);
        if (type == 0) {
            this.idleSound = sound;
        } else if (type == 1) {
            this.angrySound = sound;
        } else if (type == 2) {
            this.hurtSound = sound;
        } else if (type == 3) {
            this.deathSound = sound;
        } else if (type == 4) {
            this.stepSound = sound;
        }
    }

    public Line getInteractLine() {
        return this.interactLines.getLine(!this.orderedLines);
    }

    public Line getAttackLine() {
        return this.attackLines.getLine(!this.orderedLines);
    }

    public Line getKilledLine() {
        return this.killedLines.getLine(!this.orderedLines);
    }

    public Line getKillLine() {
        return this.killLines.getLine(!this.orderedLines);
    }

    public Line getLevelLine() {
        return this.worldLines.getLine(!this.orderedLines);
    }

    public Line getNPCInteractLine() {
        return this.npcInteractLines.getLine(!this.orderedLines);
    }

    public void setRole(int role) {
        if (8 <= role) {
            role -= 2;
        }
        if ((role %= 8) == 0) {
            this.npc.role = RoleInterface.NONE;
        } else if (role == 3 && !(this.npc.role instanceof RoleBank)) {
            this.npc.role = new RoleBank(this.npc);
        } else if (role == 2 && !(this.npc.role instanceof RoleFollower)) {
            this.npc.role = new RoleFollower(this.npc);
        } else if (role == 5 && !(this.npc.role instanceof RolePostman)) {
            this.npc.role = new RolePostman(this.npc);
        } else if (role == 1 && !(this.npc.role instanceof RoleTrader)) {
            this.npc.role = new RoleTrader(this.npc);
        } else if (role == 4 && !(this.npc.role instanceof RoleTransporter)) {
            this.npc.role = new RoleTransporter(this.npc);
        } else if (role == 6 && !(this.npc.role instanceof RoleCompanion)) {
            this.npc.role = new RoleCompanion(this.npc);
        } else if (role == 7 && !(this.npc.role instanceof RoleDialog)) {
            this.npc.role = new RoleDialog(this.npc);
        }
    }

    public void setJob(int job) {
        if (!this.npc.method_37908().field_9236) {
            this.npc.job.reset();
        }
        if ((job %= 12) == 0) {
            this.npc.job = JobInterface.NONE;
        } else if (job == 1 && !(this.npc.job instanceof JobBard)) {
            this.npc.job = new JobBard(this.npc);
        } else if (job == 2 && !(this.npc.job instanceof JobHealer)) {
            this.npc.job = new JobHealer(this.npc);
        } else if (job == 3 && !(this.npc.job instanceof JobGuard)) {
            this.npc.job = new JobGuard(this.npc);
        } else if (job == 4 && !(this.npc.job instanceof JobItemGiver)) {
            this.npc.job = new JobItemGiver(this.npc);
        } else if (job == 5 && !(this.npc.job instanceof JobFollower)) {
            this.npc.job = new JobFollower(this.npc);
        } else if (job == 6 && !(this.npc.job instanceof JobSpawner)) {
            this.npc.job = new JobSpawner(this.npc);
        } else if (job == 7 && !(this.npc.job instanceof JobConversation)) {
            this.npc.job = new JobConversation(this.npc);
        } else if (job == 8 && !(this.npc.job instanceof JobChunkLoader)) {
            this.npc.job = new JobChunkLoader(this.npc);
        } else if (job == 9 && !(this.npc.job instanceof JobPuppet)) {
            this.npc.job = new JobPuppet(this.npc);
        } else if (job == 10 && !(this.npc.job instanceof JobBuilder)) {
            this.npc.job = new JobBuilder(this.npc);
        } else if (job == 11 && !(this.npc.job instanceof JobFarmer)) {
            this.npc.job = new JobFarmer(this.npc);
        }
    }

    public boolean hasLevelLines() {
        return !this.worldLines.isEmpty();
    }
}

