/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.io.File;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.server.SPacketPlayerDataGet;

public class SPacketPlayerDataRemove
extends PacketServerBasic {
    private EnumPlayerData type;
    private String name;
    private int id;

    public SPacketPlayerDataRemove(EnumPlayerData type, String name, int id) {
        this.type = type;
        this.name = name;
        this.id = id;
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        return CustomNpcsPermissions.GLOBAL_PLAYERDATA;
    }

    public static void encode(SPacketPlayerDataRemove msg, class_2540 buf) {
        buf.method_10817((Enum)msg.type);
        buf.method_10814(msg.name);
        buf.method_53002(msg.id);
    }

    public static SPacketPlayerDataRemove decode(class_2540 buf) {
        return new SPacketPlayerDataRemove((EnumPlayerData)buf.method_10818(EnumPlayerData.class), buf.method_10800(Short.MAX_VALUE), buf.readInt());
    }

    @Override
    protected void handle() {
        Object data;
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        class_3222 pl = this.player.method_5682().method_3760().method_14566(this.name);
        PlayerData playerdata = null;
        playerdata = pl == null ? PlayerDataController.instance.getDataFromUsername(this.player.method_5682(), this.name) : PlayerData.get((class_1657)pl);
        if (this.type == EnumPlayerData.Players) {
            File file = new File(CustomNpcs.getLevelSaveDirectory("playerdata"), playerdata.uuid + ".json");
            if (file.exists()) {
                file.delete();
            }
            if (pl != null) {
                playerdata.setNBT((class_7225.class_7874)this.player.method_56673(), new class_2487());
                SPacketPlayerDataGet.sendPlayerData(this.type, this.player, this.name);
                playerdata.save(true);
                return;
            }
            PlayerDataController.instance.nameUUIDs.remove(this.name);
        }
        if (this.type == EnumPlayerData.Quest) {
            data = playerdata.questData;
            ((PlayerQuestData)data).activeQuests.remove(this.id);
            ((PlayerQuestData)data).finishedQuests.remove(this.id);
            playerdata.save(true);
        }
        if (this.type == EnumPlayerData.Dialog) {
            data = playerdata.dialogData;
            ((PlayerDialogData)data).dialogsRead.remove(this.id);
            playerdata.save(true);
        }
        if (this.type == EnumPlayerData.Transport) {
            data = playerdata.transportData;
            ((PlayerTransportData)data).transports.remove(this.id);
            playerdata.save(true);
        }
        if (this.type == EnumPlayerData.Bank) {
            data = playerdata.bankData;
            ((PlayerBankData)data).banks.remove(this.id);
            playerdata.save(true);
        }
        if (this.type == EnumPlayerData.Factions) {
            data = playerdata.factionData;
            ((PlayerFactionData)data).factionData.remove(this.id);
            playerdata.save(true);
        }
        if (pl != null) {
            SyncController.syncPlayer(pl);
        }
        SPacketPlayerDataGet.sendPlayerData(this.type, this.player, this.name);
    }
}

