/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.quests.QuestInterface;

public class QuestDialog
extends QuestInterface {
    public HashMap<Integer, Integer> dialogs = new HashMap();

    @Override
    public void readAdditionalSaveData(class_7225.class_7874 lookupProvider, class_2487 compound) {
        this.dialogs = NBTTags.getIntegerIntegerMap(compound.method_10554("QuestDialogs", 10));
    }

    @Override
    public void addAdditionalSaveData(class_7225.class_7874 lookupProvider, class_2487 compound) {
        compound.method_10566("QuestDialogs", (class_2520)NBTTags.nbtIntegerIntegerMap(this.dialogs));
    }

    @Override
    public boolean isCompleted(class_1657 player) {
        for (int dialogId : this.dialogs.values()) {
            if (PlayerData.get((class_1657)player).dialogData.dialogsRead.contains(dialogId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleComplete(class_1657 player) {
    }

    @Override
    public IQuestObjective[] getObjectives(class_1657 player) {
        ArrayList<QuestDialogObjective> list = new ArrayList<QuestDialogObjective>();
        for (int i = 0; i < 3; ++i) {
            Dialog dialog;
            if (!this.dialogs.containsKey(i) || (dialog = DialogController.instance.dialogs.get(this.dialogs.get(i))) == null) continue;
            list.add(new QuestDialogObjective(this, player, dialog));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    class QuestDialogObjective
    implements IQuestObjective {
        private final class_1657 player;
        private final Dialog dialog;

        public QuestDialogObjective(QuestDialog this$0, class_1657 player, Dialog dialog) {
            this.player = player;
            this.dialog = dialog;
        }

        @Override
        public int getProgress() {
            return this.isCompleted() ? 1 : 0;
        }

        @Override
        public void setProgress(int progress) {
            if (progress < 0 || progress > 1) {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
            PlayerData data = PlayerData.get(this.player);
            boolean completed = data.dialogData.dialogsRead.contains(this.dialog.id);
            if (progress == 0 && completed) {
                data.dialogData.dialogsRead.remove(this.dialog.id);
                data.questData.checkQuestCompletion(this.player, 1);
                data.updateClient = true;
            }
            if (progress == 1 && !completed) {
                data.dialogData.dialogsRead.add(this.dialog.id);
                data.questData.checkQuestCompletion(this.player, 1);
                data.updateClient = true;
            }
        }

        @Override
        public int getMaxProgress() {
            return 1;
        }

        @Override
        public boolean isCompleted() {
            PlayerData data = PlayerData.get(this.player);
            return data.dialogData.dialogsRead.contains(this.dialog.id);
        }

        @Override
        public String getText() {
            return this.getMCText().getString();
        }

        @Override
        public class_2561 getMCText() {
            return class_2561.method_43471((String)this.dialog.title).method_27693(" (").method_10852((class_2561)class_2561.method_43471((String)(this.isCompleted() ? "quest.read" : "quest.unread"))).method_27693(")");
        }
    }
}

