/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1208;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3551;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import noppes.npcs.CustomBlocks;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.shared.common.CommonUtil;

public class SpongeSchem
implements ISchematic {
    public static final int latestDataVersion = 2586;
    public String name;
    public short width;
    public short height;
    public short length;
    public long timestamp = System.currentTimeMillis();
    public int[] data;
    public Map<Integer, class_2680> palette = new HashMap<Integer, class_2680>();
    public List<class_2487> tileData = new ArrayList<class_2487>();

    public SpongeSchem(String name) {
        this.name = name;
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    public int getBlockEntityDimensions() {
        return this.tileData.size();
    }

    @Override
    public class_2487 getBlockEntity(int i) {
        return this.tileData.get(i);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public class_2680 getBlockState(int x, int y, int z) {
        return this.getBlockState(this.xyzToIndex(x, y, z));
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }

    @Override
    public class_2680 getBlockState(int i) {
        return this.palette.get(this.data[i]);
    }

    @Override
    public class_2487 getNBT() {
        class_2487 root = new class_2487();
        class_2487 compound = new class_2487();
        root.method_10566("", (class_2520)compound);
        class_2487 data = new class_2487();
        compound.method_10566("Schematic", (class_2520)data);
        data.method_10569("Width", (int)this.width);
        data.method_10569("Height", (int)this.height);
        data.method_10569("Length", (int)this.length);
        data.method_10569("Version", 3);
        data.method_10569("DataVersion", 2586);
        class_2487 metadata = new class_2487();
        metadata.method_10544("Date", this.timestamp);
        data.method_10566("Metadata", (class_2520)metadata);
        class_2487 blockData = new class_2487();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            int blockId = this.data[i];
            while ((blockId & 0xFFFFFF80) != 0) {
                buffer.write(blockId & 0x7F | 0x80);
                blockId >>>= 7;
            }
            buffer.write(blockId);
        }
        blockData.method_10570("Data", buffer.toByteArray());
        class_2487 palletteNBT = new class_2487();
        for (Map.Entry<Integer, class_2680> en : this.palette.entrySet()) {
            palletteNBT.method_10569(class_2259.method_9685((class_2680)en.getValue()), en.getKey().intValue());
        }
        blockData.method_10566("Palette", (class_2520)palletteNBT);
        class_2499 tileNBT = new class_2499();
        for (class_2487 tile : this.tileData) {
            tile = tile.method_10553();
            tile.method_10539("Pos", new int[]{tile.method_10550("x"), tile.method_10550("y"), tile.method_10550("z")});
            tile.method_10582("Id", tile.method_10558("id"));
            tile.method_10551("x");
            tile.method_10551("y");
            tile.method_10551("z");
            tile.method_10551("id");
            tileNBT.add((Object)tile);
        }
        blockData.method_10566("BlockEntities", (class_2520)tileNBT);
        data.method_10566("Blocks", (class_2520)blockData);
        return root;
    }

    public void load(class_2487 compound) {
        int version;
        if (compound.method_10546() == 1) {
            compound = compound.method_10562("").method_10562("Schematic");
        }
        this.width = compound.method_10568("Width");
        this.height = compound.method_10568("Height");
        this.length = compound.method_10568("Length");
        class_2487 metadata = compound.method_10562("Metadata");
        this.timestamp = 0L;
        if (!metadata.method_33133()) {
            this.timestamp = metadata.method_10537("Date");
        }
        int dataVersion = 1631;
        if (compound.method_10545("DataVersion")) {
            dataVersion = compound.method_10550("DataVersion");
            if (dataVersion > 2586) {
                // empty if block
            }
            if (dataVersion < 2586) {
                // empty if block
            }
        }
        if ((version = compound.method_10550("Version")) < 3) {
            this.palette = this.readPalette(compound.method_10562("Palette"), dataVersion);
            class_2499 tileEntities = compound.method_10554("BlockEntities", 10);
            if (tileEntities.isEmpty()) {
                tileEntities = compound.method_10554("TileEntities", 10);
            }
            this.tileData = this.readTileData(tileEntities, dataVersion);
            this.data = this.readBlockData(compound.method_10547("BlockData"));
        } else {
            class_2487 blocks = compound.method_10562("Blocks");
            this.palette = this.readPalette(blocks.method_10562("Palette"), dataVersion);
            this.tileData = this.readTileData(blocks.method_10554("BlockEntities", 10), dataVersion);
            this.data = this.readBlockData(blocks.method_10547("Data"));
        }
    }

    private int[] readBlockData(byte[] bytes) {
        int[] data = new int[this.width * this.length * this.height];
        int index = 0;
        int i = 0;
        while (i < bytes.length) {
            int value = 0;
            int varintLength = 0;
            while (true) {
                value |= (bytes[i] & 0x7F) << varintLength++ * 7;
                if (varintLength > 5) {
                    throw new CustomNPCsException("VarInt too big (probably corrupted data)", new Object[0]);
                }
                if ((bytes[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            data[index] = value;
            ++index;
        }
        return data;
    }

    private Map<Integer, class_2680> readPalette(class_2487 comp, int dataVersion) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<Integer, class_2680> palette = new HashMap<Integer, class_2680>();
        for (String blockState : comp.method_10541()) {
            int id = comp.method_10550(blockState);
            if (dataVersion < 2586) {
                class_2487 stateNBT = SpongeSchem.stateToNBT(blockState);
                Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)stateNBT);
                stateNBT = (class_2487)class_3551.method_15450().update(class_1208.field_5720, dynamic, dataVersion, 2586).getValue();
                blockState = this.nbtToState(stateNBT);
            }
            map.put(blockState, id);
        }
        for (class_2248 block : class_7923.field_41175) {
            block.method_9595().method_11662().forEach(state -> {
                String name = class_2259.method_9685((class_2680)state);
                if (map.containsKey(name)) {
                    int id = (Integer)map.remove(name);
                    palette.put(id, (class_2680)state);
                }
            });
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            palette.put(id, class_2246.field_10124.method_9564());
        }
        return palette;
    }

    private List<class_2487> readTileData(class_2499 list, int dataVersion) {
        ArrayList<class_2487> tileData = new ArrayList<class_2487>();
        if (list.isEmpty()) {
            return tileData;
        }
        for (int i = 0; i < list.size(); ++i) {
            class_2487 data = list.method_10602(i);
            int[] posArr = data.method_10561("Pos");
            class_2338 pos = new class_2338(posArr[0], posArr[1], posArr[2]);
            data.method_10569("x", pos.method_10263());
            data.method_10569("y", pos.method_10264());
            data.method_10569("z", pos.method_10260());
            data.method_10566("id", data.method_10580("Id"));
            data.method_10551("Id");
            data.method_10551("Pos");
            if (dataVersion < 2586) {
                Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)data);
                data = (class_2487)class_3551.method_15450().update(class_1208.field_5727, dynamic, dataVersion, 2586).getValue();
            } else {
                data = data.method_10553();
            }
            tileData.add(data);
        }
        return tileData;
    }

    private String nbtToState(class_2487 tagCompound) {
        StringBuilder sb = new StringBuilder();
        sb.append(tagCompound.method_10558("Name"));
        if (tagCompound.method_10573("Properties", 10)) {
            sb.append('[');
            class_2487 props = tagCompound.method_10562("Properties");
            sb.append(props.method_10541().stream().map(k -> k + "=" + props.method_10558(k).replace("\"", "")).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static class_2487 stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        class_2487 tag = new class_2487();
        if (propIdx < 0) {
            tag.method_10582("Name", blockState);
        } else {
            String[] propArr;
            tag.method_10582("Name", blockState.substring(0, propIdx));
            class_2487 propTag = new class_2487();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            for (String pair : propArr = props.split(",")) {
                String[] split = pair.split("=");
                propTag.method_10582(split[0], split[1]);
            }
            tag.method_10566("Properties", (class_2520)propTag);
        }
        return tag;
    }

    public static SpongeSchem Create(class_1937 level, String name, class_2338 pos, short height, short width, short length) {
        SpongeSchem schema = new SpongeSchem(name);
        schema.height = height;
        schema.width = width;
        schema.length = length;
        int size = height * width * length;
        CommonUtil.NotifyOPs(level.method_8503(), "Creating schematic at: " + String.valueOf(pos) + " might lag slightly", new Object[0]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        schema.data = new int[size];
        int uniqueBlockId = 0;
        for (int i = 0; i < size; ++i) {
            int x = i % width;
            int z = (i - x) / width % length;
            int y = ((i - x) / width - z) / length;
            class_2680 state = level.method_8320(pos.method_10069(x, y, z));
            if (state.method_26204() == CustomBlocks.copy) continue;
            String stateName = class_2259.method_9685((class_2680)state);
            Integer blockId = (Integer)map.get(stateName);
            if (!map.containsKey(stateName)) {
                blockId = uniqueBlockId++;
                map.put(stateName, blockId);
            }
            schema.palette.put(blockId, state);
            schema.data[i] = blockId;
            if (!(state.method_26204() instanceof class_2343)) continue;
            class_2586 tile = level.method_8321(pos.method_10069(x, y, z));
            class_2487 compound = tile.method_38242((class_7225.class_7874)level.method_30349());
            compound.method_10569("x", x);
            compound.method_10569("y", y);
            compound.method_10569("z", z);
            schema.tileData.add(compound);
        }
        return schema;
    }
}

