/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.entity.EntityNPCInterface;

public class CustomGuiEntityDisplay
extends AbstractWidget
implements IGuiComponent {
    private GuiCustom parent;
    public CustomGuiEntityDisplayWrapper component;
    private Entity entity;
    public int id;

    public CustomGuiEntityDisplay(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.m_237119_());
        this.component = component;
        this.parent = parent;
        this.init();
    }

    public void init() {
        this.id = this.component.getID();
        this.f_93620_ = this.component.getPosX();
        this.f_93621_ = this.component.getPosY();
        this.m_93674_(this.component.getWidth());
        this.setHeight(this.component.getHeight());
        if (!this.component.getEntityData().isEmpty()) {
            this.entity = EntityType.m_20642_((CompoundTag)this.component.getEntityData().getMCNBT(), (Level)Minecraft.m_91087_().f_91073_).orElse(null);
        }
        this.f_93623_ = this.component.getEnabled() && this.component.getVisible();
        this.f_93624_ = this.component.getVisible();
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean hovered;
        if (!this.f_93624_) {
            return;
        }
        if (this.component.getBackground()) {
            this.m_93179_(matrixStack, this.f_93620_, this.f_93621_, this.f_93618_ + this.f_93620_, this.f_93619_ + this.f_93621_, -1072689136, -804253680);
        }
        if (this.entity != null) {
            CustomGuiEntityDisplay.drawEntity(this.entity, this.f_93620_, this.f_93621_, this.component.getScale(), this.component.getRotation() / 2 + 180, mouseX, mouseY, (float)this.f_93618_ / 2.0f, (float)this.f_93619_ * 0.9f);
        }
        boolean bl = hovered = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        if (hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
    }

    protected int m_7202_(boolean p_getYImage_1_) {
        return 0;
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        return true;
    }

    public static CustomGuiEntityDisplay fromComponent(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        CustomGuiEntityDisplay btn = new CustomGuiEntityDisplay(parent, component);
        return btn;
    }

    public static void drawEntity(Entity entity, int x, int y, float zoomed, int rotation, int xMouse, int yMouse, float guiLeft, float guiTop) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        LivingEntity livingEntity = null;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
        }
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f2 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (livingEntity != null) {
            f2 = livingEntity.f_20883_;
            f5 = livingEntity.f_20886_;
            f6 = livingEntity.f_20885_;
        }
        float scale = 1.0f;
        if ((double)entity.m_20206_() > 2.4) {
            scale = 2.0f / entity.m_20206_();
        }
        float f7 = guiLeft + (float)x - (float)xMouse;
        float f8 = (guiTop + (float)y - 50.0f * scale * zoomed) * (entity.m_20206_() / entity.m_20192_()) - (float)yMouse;
        entity.m_146922_((float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation);
        entity.m_146926_(-((float)Math.atan(f8 / 40.0f)) * 20.0f);
        if (livingEntity != null) {
            livingEntity.f_20885_ = livingEntity.f_20883_ = entity.m_146908_();
            livingEntity.f_20886_ = livingEntity.f_20883_;
        }
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = (int)entity.m_146908_();
        }
        float fs = 30.0f * scale * zoomed;
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)(guiLeft + (float)x), (double)(guiTop + (float)y), 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(0.0, 0.0, 1000.0);
        matrixStack.m_85841_(fs, fs, fs);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_((float)rotation));
        Lighting.m_166384_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)buffersource, 0xF000F0));
        buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        if (livingEntity != null) {
            livingEntity.f_20883_ = f2;
            livingEntity.f_20886_ = f5;
            livingEntity.f_20885_ = f6;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }
}

