/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketRecipeGet;
import noppes.npcs.packets.server.SPacketRecipeRemove;
import noppes.npcs.packets.server.SPacketRecipeSave;
import noppes.npcs.packets.server.SPacketRecipesGet;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiButtonYesNo;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiData;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.gui.listeners.IScrollData;
import noppes.npcs.shared.client.gui.listeners.ITextfieldListener;

public class GuiNpcManageRecipes
extends GuiContainerNPCInterface2<ContainerManageRecipes>
implements IScrollData,
IGuiData,
ICustomScrollListener,
ITextfieldListener {
    private GuiCustomScrollNop scroll;
    private Map<String, Integer> data = new HashMap<String, Integer>();
    private ContainerManageRecipes container;
    private String selected = null;
    private ResourceLocation slot;

    public GuiNpcManageRecipes(ContainerManageRecipes container, Inventory inv, Component titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.drawDefaultBackground = false;
        Packets.sendServer(new SPacketRecipesGet(container.width));
        this.setBackground("inventorymenu.png");
        this.slot = this.getResource("slot.png");
        this.f_97727_ = 200;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScrollNop((Screen)this, 0);
        }
        this.scroll.setSize(130, 180);
        this.scroll.guiLeft = this.guiLeft + 172;
        this.scroll.guiTop = this.guiTop + 8;
        this.addScroll(this.scroll);
        this.addButton(new GuiButtonNop(this, 0, this.guiLeft + 306, this.guiTop + 10, 84, 20, "menu.global"));
        this.addButton(new GuiButtonNop(this, 1, this.guiLeft + 306, this.guiTop + 32, 84, 20, "block.customnpcs.npccarpentybench"));
        this.getButton(0).setEnabled(this.container.width == 4);
        this.getButton(1).setEnabled(this.container.width == 3);
        this.addButton(new GuiButtonNop(this, 3, this.guiLeft + 306, this.guiTop + 60, 84, 20, "gui.add"));
        this.addButton(new GuiButtonNop(this, 4, this.guiLeft + 306, this.guiTop + 82, 84, 20, "gui.remove"));
        this.addLabel(new GuiLabel(0, "gui.ignoreDamage", this.guiLeft + 86, this.guiTop + 32));
        this.addButton(new GuiButtonYesNo((IGuiInterface)this, 5, this.guiLeft + 114, this.guiTop + 40, 50, 20, this.container.recipe.ignoreDamage));
        this.addLabel(new GuiLabel(1, "gui.ignoreNBT", this.guiLeft + 86, this.guiTop + 82));
        this.addButton(new GuiButtonYesNo((IGuiInterface)this, 6, this.guiLeft + 114, this.guiTop + 90, 50, 20, this.container.recipe.ignoreNBT));
        this.addTextField(new GuiTextFieldNop(0, (Screen)this, this.guiLeft + 8, this.guiTop + 8, 160, 20, this.container.recipe.name));
        this.getTextField((int)0).enabled = false;
        this.getButton(5).setEnabled(false);
        this.getButton(6).setEnabled(false);
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        GuiButtonNop button = guibutton;
        if (button.id == 0) {
            this.save();
            NoppesUtil.requestOpenGUI(EnumGuiType.ManageRecipes, new BlockPos(3, 0, 0));
        }
        if (button.id == 1) {
            this.save();
            NoppesUtil.requestOpenGUI(EnumGuiType.ManageRecipes, new BlockPos(4, 0, 0));
        }
        if (button.id == 3) {
            this.save();
            this.scroll.clear();
            Object name = I18n.m_118938_((String)"gui.new", (Object[])new Object[0]);
            while (this.data.containsKey(name)) {
                name = (String)name + "_";
            }
            RecipeCarpentry recipe = new RecipeCarpentry(new ResourceLocation("customnpcs", (String)name), (String)name);
            recipe.isGlobal = this.container.width == 3;
            Packets.sendServer(new SPacketRecipeSave(recipe.writeNBT()));
        }
        if (button.id == 4 && this.data.containsKey(this.scroll.getSelected())) {
            Packets.sendServer(new SPacketRecipeRemove(this.data.get(this.scroll.getSelected())));
            this.scroll.clear();
        }
        if (button.id == 5) {
            boolean bl = this.container.recipe.ignoreDamage = button.getValue() == 1;
        }
        if (button.id == 6) {
            this.container.recipe.ignoreNBT = button.getValue() == 1;
        }
    }

    @Override
    public void setGuiData(CompoundTag compound) {
        RecipeCarpentry recipe = RecipeCarpentry.load(compound);
        this.getTextField(0).m_94144_(recipe.name);
        this.container.setRecipe(recipe);
        this.getTextField((int)0).enabled = true;
        this.getButton(5).setEnabled(true);
        this.getButton(5).setDisplay(recipe.ignoreDamage ? 1 : 0);
        this.getButton(6).setEnabled(true);
        this.getButton(6).setDisplay(recipe.ignoreNBT ? 1 : 0);
        this.setSelected(recipe.name);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float f, int x, int y) {
        super.m_7286_(matrixStack, f, x, y);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.slot);
        for (int i = 0; i < this.container.width; ++i) {
            for (int j = 0; j < this.container.width; ++j) {
                this.m_93228_(matrixStack, this.guiLeft + i * 18 + 7, this.guiTop + j * 18 + 34, 0, 0, 18, 18);
            }
        }
        this.m_93228_(matrixStack, this.guiLeft + 86, this.guiTop + 60, 0, 0, 18, 18);
    }

    @Override
    public void setData(Vector<String> list, Map<String, Integer> data) {
        String name = this.scroll.getSelected();
        this.data = data;
        this.scroll.setList(list);
        this.getTextField((int)0).enabled = name != null;
        this.getButton(5).setEnabled(name != null);
        if (name != null) {
            this.scroll.setSelected(name);
        }
    }

    @Override
    public void setSelected(String selected) {
        this.selected = selected;
        this.scroll.setSelected(selected);
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScrollNop guiCustomScroll) {
        this.save();
        this.selected = this.scroll.getSelected();
        Packets.sendServer(new SPacketRecipeGet(this.data.get(this.selected)));
    }

    @Override
    public void save() {
        GuiTextFieldNop.unfocus();
        if (this.selected != null && this.data.containsKey(this.selected)) {
            this.container.saveRecipe();
            Packets.sendServer(new SPacketRecipeSave(this.container.recipe.writeNBT()));
        }
    }

    @Override
    public void unFocused(GuiTextFieldNop guiNpcTextField) {
        String name = guiNpcTextField.m_94155_();
        if (!name.isEmpty() && !this.data.containsKey(name)) {
            String old = this.container.recipe.name;
            this.data.remove(this.container.recipe.name);
            this.container.recipe.name = name;
            this.selected = name;
            this.scroll.replace(old, this.container.recipe.name);
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
    }
}

