/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.tabs.InventoryTabFactions;
import noppes.npcs.client.gui.player.tabs.InventoryTabQuests;
import noppes.npcs.client.gui.player.tabs.InventoryTabVanilla;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.shared.client.gui.components.GuiButtonNextPage;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiFaction
extends GuiNPCInterface {
    private ArrayList<Faction> playerFactions = new ArrayList();
    private PlayerFactionData data;
    private int page = 0;
    private int pages = 1;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private ResourceLocation indicator;

    public GuiFaction() {
        this.imageWidth = 200;
        this.imageHeight = 195;
        this.drawDefaultBackground = false;
        this.title = "";
        this.indicator = this.getResource("standardbg.png");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.data = PlayerData.get((Player)this.player).factionData;
        this.playerFactions = new ArrayList();
        for (int id : this.data.factionData.keySet()) {
            Faction faction = FactionController.instance.getFaction(id);
            if (faction == null || faction.hideFaction) continue;
            this.playerFactions.add(faction);
        }
        this.pages = (this.playerFactions.size() - 1) / 5;
        ++this.pages;
        this.page = 1;
        this.guiLeft = (this.f_96543_ - this.imageWidth) / 2;
        this.guiTop += 12;
        this.m_142416_((GuiEventListener)new InventoryTabVanilla().init(this));
        this.m_142416_((GuiEventListener)new InventoryTabFactions().init(this));
        this.m_142416_((GuiEventListener)new InventoryTabQuests().init(this));
        this.buttonNextPage = new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + this.imageWidth - 43, this.guiTop + 180, true, button -> {
            ++this.page;
            this.updateButtons();
        });
        this.addButton(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 20, this.guiTop + 180, false, button -> {
            --this.page;
            this.updateButtons();
        });
        this.addButton(this.buttonPreviousPage);
        this.updateButtons();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.indicator);
        this.m_93228_(matrixStack, this.guiLeft, this.guiTop + 8, 0, 0, this.imageWidth, this.imageHeight);
        this.m_93228_(matrixStack, this.guiLeft + 4, this.guiTop + 8, 56, 0, 200, this.imageHeight);
        if (this.playerFactions.isEmpty()) {
            MutableComponent noFaction = Component.m_237115_((String)"faction.nostanding");
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(matrixStack, (Component)noFaction, (float)(this.guiLeft + (this.imageWidth - font.m_92852_((FormattedText)noFaction)) / 2), (float)(this.guiTop + 80), CustomNpcResourceListener.DefaultTextColor);
        } else {
            this.renderScreen(matrixStack);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScreen(PoseStack matrixStack) {
        int size = 5;
        if (this.playerFactions.size() % 5 != 0 && this.page == this.pages) {
            size = this.playerFactions.size() % 5;
        }
        for (int id = 0; id < size; ++id) {
            this.m_93154_(matrixStack, this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + id * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
            Faction faction = this.playerFactions.get((this.page - 1) * 5 + id);
            MutableComponent name = Component.m_237115_((String)faction.name);
            int current = this.data.factionData.get(faction.id);
            String points = " : " + current;
            MutableComponent standing = Component.m_237115_((String)"faction.friendly");
            int color = 65280;
            if (current < faction.neutralPoints) {
                standing = Component.m_237115_((String)"faction.unfriendly");
                color = 0xFF0000;
                points = points + "/" + faction.neutralPoints;
            } else if (current < faction.friendlyPoints) {
                standing = Component.m_237115_((String)"faction.neutral");
                color = 0xF2FF00;
                points = points + "/" + faction.friendlyPoints;
            } else {
                points = points + "/-";
            }
            this.f_96547_.m_92889_(matrixStack, (Component)name, (float)(this.guiLeft + (this.imageWidth - this.f_96547_.m_92852_((FormattedText)name)) / 2), (float)(this.guiTop + 19 + id * 30), faction.color);
            this.f_96547_.m_92889_(matrixStack, (Component)standing, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)standing) - 1), (float)(this.guiTop + 33 + id * 30), color);
            this.f_96547_.m_92883_(matrixStack, points, (float)(this.f_96543_ / 2), (float)(this.guiTop + 33 + id * 30), CustomNpcResourceListener.DefaultTextColor);
        }
        this.m_93154_(matrixStack, this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + size * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        if (this.pages > 1) {
            String s = this.page + "/" + this.pages;
            this.f_96547_.m_92883_(matrixStack, s, (float)(this.guiLeft + (this.imageWidth - this.f_96547_.m_92895_(s)) / 2), (float)(this.guiTop + 203), CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        if (!(guibutton instanceof GuiButtonNextPage)) {
            return;
        }
        int id = guibutton.id;
        if (id == 1) {
            ++this.page;
        }
        if (id == 2) {
            --this.page;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.f_93624_ = this.page < this.pages;
        this.buttonPreviousPage.f_93624_ = this.page > 1;
    }

    @Override
    public void save() {
    }
}

