/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.model.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import noppes.npcs.shared.client.model.util.CustomRenderStates;
import noppes.npcs.shared.client.model.util.Vertex;
import noppes.npcs.shared.common.util.NopVector3f;
import org.lwjgl.opengl.GL21;

public class Mesh {
    public int[] indices;
    public Vertex[] vertices;
    public NopVector3f[] normals;
    private int vbo = -1;

    public int getVbo() {
        if (this.vbo == -1) {
            NopVector3f normal;
            if (this.normals == null) {
                this.normals = new NopVector3f[this.indices.length];
                for (int i = 0; i < this.normals.length / 3; ++i) {
                    Vector3f v1 = this.vertices[this.indices[i * 3]].pos;
                    Vector3f v2 = this.vertices[this.indices[i * 3 + 1]].pos;
                    Vector3f v3 = this.vertices[this.indices[i * 3 + 2]].pos;
                    this.normals[i * 3] = normal = Mesh.calcNormal(v1, v2, v3);
                    this.normals[i * 3 + 1] = normal;
                    this.normals[i * 3 + 2] = normal;
                }
            }
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, CustomRenderStates.POS_TEX_NORMAL);
            for (int i = 0; i < this.indices.length; ++i) {
                Vertex vertex = this.vertices[this.indices[i]];
                normal = this.normals[i];
                bufferBuilder.m_5483_((double)vertex.pos.m_122239_(), (double)vertex.pos.m_122260_(), (double)vertex.pos.m_122269_());
                bufferBuilder.m_7421_(vertex.texCoords.x, 1.0f - vertex.texCoords.y);
                bufferBuilder.m_5601_(normal.x, normal.y, normal.z);
                bufferBuilder.m_5752_();
            }
            bufferBuilder.m_231175_();
            this.vbo = GL21.glGenBuffers();
            GL21.glBindBuffer((int)34962, (int)this.vbo);
            GL21.glBindBuffer((int)34962, (int)0);
        }
        return this.vbo;
    }

    private static NopVector3f calcNormal(Vector3f v1, Vector3f v2, Vector3f v3) {
        NopVector3f calU = new NopVector3f(v2.m_122239_() - v1.m_122239_(), v2.m_122260_() - v1.m_122260_(), v2.m_122269_() - v1.m_122269_());
        NopVector3f calV = new NopVector3f(v3.m_122239_() - v1.m_122239_(), v3.m_122260_() - v1.m_122260_(), v3.m_122269_() - v1.m_122269_());
        NopVector3f output = new NopVector3f(calU.y * calV.z - calU.z * calV.y, calU.z * calV.x - calU.x * calV.z, calU.x * calV.y - calU.y * calV.x);
        return output.normalize();
    }

    public void delete() {
        if (this.vbo != -1) {
            GL21.glDeleteBuffers((int)this.vbo);
            this.vbo = -1;
        }
    }
}

