/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.shared.common.util.LogWriter;
import org.apache.commons.lang3.StringUtils;

public class ForgeEventHandler {
    public static List<String> eventNames = new ArrayList<String>();

    @SubscribeEvent
    public void forgeEntity(Event event) {
        if (CustomNpcs.Server == null || !ScriptController.Instance.forgeScripts.isEnabled()) {
            return;
        }
        try {
            if (event instanceof PlayerEvent) {
                PlayerEvent ev = (PlayerEvent)event;
                if (!(ev.getPlayer().field_70170_p instanceof ServerWorld)) {
                    return;
                }
            }
            if (event instanceof EntityEvent) {
                EntityEvent ev2 = (EntityEvent)event;
                if (ev2.getEntity() == null || !(ev2.getEntity().field_70170_p instanceof ServerWorld)) {
                    return;
                }
                EventHooks.onForgeEntityEvent(ev2);
            } else if (event instanceof WorldEvent) {
                WorldEvent ev3 = (WorldEvent)event;
                if (!(ev3.getWorld() instanceof ServerWorld)) {
                    return;
                }
                EventHooks.onForgeWorldEvent(ev3);
            } else {
                if (event instanceof TickEvent && ((TickEvent)event).side == LogicalSide.CLIENT) {
                    return;
                }
                EventHooks.onForgeEvent(new ForgeEvent(event), event);
            }
        }
        catch (Throwable t) {
            LogWriter.error("Error in " + event.getClass().getName(), t);
        }
    }

    public static String getEventName(Class c) {
        String eventName = c.getName();
        int i = eventName.lastIndexOf(".");
        return StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", ""));
    }
}

