/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;

public class NBTTags {
    public static void getItemStackList(ListNBT tagList, NonNullList<ItemStack> items) {
        items.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            try {
                items.set(nbttagcompound.func_74771_c("Slot") & 0xFF, (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
                continue;
            }
            catch (ClassCastException e) {
                items.set(nbttagcompound.func_74762_e("Slot"), (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
            }
        }
    }

    public static Map<Integer, IItemStack> getIItemStackMap(ListNBT tagList) {
        HashMap<Integer, IItemStack> list = new HashMap<Integer, IItemStack>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)nbttagcompound);
            if (item.func_190926_b()) continue;
            try {
                list.put(nbttagcompound.func_74771_c("Slot") & 0xFF, NpcAPI.Instance().getIItemStack(item));
                continue;
            }
            catch (ClassCastException e) {
                list.put(nbttagcompound.func_74762_e("Slot"), NpcAPI.Instance().getIItemStack(item));
            }
        }
        return list;
    }

    public static ItemStack[] getItemStackArray(ListNBT tagList) {
        ItemStack[] list = new ItemStack[tagList.size()];
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list[nbttagcompound.func_74771_c((String)"Slot") & 0xFF] = ItemStack.func_199557_a((CompoundNBT)nbttagcompound);
        }
        return list;
    }

    public static NonNullList<Ingredient> getIngredientList(ListNBT tagList) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.add(nbttagcompound.func_74771_c("Slot") & 0xFF, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.func_199557_a((CompoundNBT)nbttagcompound)}));
        }
        return list;
    }

    public static ArrayList<int[]> getIntegerArraySet(ListNBT tagList) {
        ArrayList<int[]> set = new ArrayList<int[]>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT compound = tagList.func_150305_b(i);
            set.add(compound.func_74759_k("Array"));
        }
        return set;
    }

    public static HashMap<Integer, Boolean> getBooleanList(ListNBT tagList) {
        HashMap<Integer, Boolean> list = new HashMap<Integer, Boolean>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74767_n("Boolean"));
        }
        return list;
    }

    public static HashMap<Integer, Integer> getIntegerIntegerMap(ListNBT tagList) {
        HashMap<Integer, Integer> list = new HashMap<Integer, Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static HashMap<Integer, Long> getIntegerLongMap(ListNBT tagList) {
        HashMap<Integer, Long> list = new HashMap<Integer, Long>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74763_f("Long"));
        }
        return list;
    }

    public static HashSet<Integer> getIntegerSet(ListNBT tagList) {
        HashSet<Integer> list = new HashSet<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.add(nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static List<Integer> getIntegerList(ListNBT tagList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.add(nbttagcompound.func_74762_e("Integer"));
        }
        return list;
    }

    public static HashMap<String, String> getStringStringMap(ListNBT tagList) {
        HashMap<String, String> list = new HashMap<String, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74779_i("Slot"), nbttagcompound.func_74779_i("Value"));
        }
        return list;
    }

    public static HashMap<Integer, String> getIntegerStringMap(ListNBT tagList) {
        HashMap<Integer, String> list = new HashMap<Integer, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74762_e("Slot"), nbttagcompound.func_74779_i("Value"));
        }
        return list;
    }

    public static HashMap<String, Integer> getStringIntegerMap(ListNBT tagList) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74779_i("Slot"), nbttagcompound.func_74762_e("Value"));
        }
        return list;
    }

    public static HashMap<String, Vector<String>> getVectorMap(ListNBT tagList) {
        HashMap<String, Vector<String>> map = new HashMap<String, Vector<String>>();
        for (int i = 0; i < tagList.size(); ++i) {
            Vector<String> values = new Vector<String>();
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            ListNBT list = nbttagcompound.func_150295_c("Values", 10);
            for (int j = 0; j < list.size(); ++j) {
                CompoundNBT value = list.func_150305_b(j);
                values.add(value.func_74779_i("Value"));
            }
            map.put(nbttagcompound.func_74779_i("Key"), values);
        }
        return map;
    }

    public static List<String> getStringList(ListNBT tagList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            String line = nbttagcompound.func_74779_i("Line");
            list.add(line);
        }
        return list;
    }

    public static List<ResourceLocation> getResourceLocationList(ListNBT tagList) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            ResourceLocation line = new ResourceLocation(nbttagcompound.func_74779_i("Line"));
            list.add(line);
        }
        return list;
    }

    public static String[] getStringArray(ListNBT tagList, int size) {
        String[] arr = new String[size];
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            String line = nbttagcompound.func_74779_i("Value");
            int slot = nbttagcompound.func_74762_e("Slot");
            arr[slot] = line;
        }
        return arr;
    }

    public static ListNBT nbtIntegerArraySet(List<int[]> set) {
        ListNBT nbttaglist = new ListNBT();
        if (set == null) {
            return nbttaglist;
        }
        for (int[] arr : set) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74783_a("Array", arr);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtItemStackList(NonNullList<ItemStack> inventory) {
        ListNBT nbttaglist = new ListNBT();
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack item = (ItemStack)inventory.get(slot);
            if (item.func_190926_b()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            item.func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtIItemStackMap(Map<Integer, IItemStack> inventory) {
        ListNBT nbttaglist = new ListNBT();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot : inventory.keySet()) {
            IItemStack item = inventory.get(slot);
            if (item == null) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            item.getMCItemStack().func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtItemStackArray(ItemStack[] inventory) {
        ListNBT nbttaglist = new ListNBT();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot = 0; slot < inventory.length; ++slot) {
            ItemStack item = inventory[slot];
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            if (item != null) {
                item.func_77955_b(nbttagcompound);
            }
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtIngredientList(NonNullList<Ingredient> inventory) {
        ListNBT nbttaglist = new ListNBT();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot = 0; slot < inventory.size(); ++slot) {
            Ingredient ingredient = (Ingredient)inventory.get(slot);
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            if (ingredient != null && ingredient.func_193365_a().length > 0) {
                ingredient.func_193365_a()[0].func_77955_b(nbttagcompound);
            }
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtBooleanList(HashMap<Integer, Boolean> updatedSlots) {
        ListNBT nbttaglist = new ListNBT();
        if (updatedSlots == null) {
            return nbttaglist;
        }
        HashMap<Integer, Boolean> inventory2 = updatedSlots;
        for (Integer slot : inventory2.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", slot.intValue());
            nbttagcompound.func_74757_a("Boolean", inventory2.get(slot).booleanValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtIntegerIntegerMap(Map<Integer, Integer> lines) {
        ListNBT nbttaglist = new ListNBT();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74768_a("Integer", lines.get(slot).intValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtIntegerLongMap(HashMap<Integer, Long> lines) {
        ListNBT nbttaglist = new ListNBT();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74772_a("Long", lines.get(slot).longValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtIntegerCollection(Collection<Integer> set) {
        ListNBT nbttaglist = new ListNBT();
        if (set == null) {
            return nbttaglist;
        }
        for (int slot : set) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Integer", slot);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtVectorMap(HashMap<String, Vector<String>> map) {
        ListNBT list = new ListNBT();
        if (map == null) {
            return list;
        }
        for (String key : map.keySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("Key", key);
            ListNBT values = new ListNBT();
            for (String value : map.get(key)) {
                CompoundNBT comp = new CompoundNBT();
                comp.func_74778_a("Value", value);
                values.add((Object)comp);
            }
            compound.func_218657_a("Values", (INBT)values);
            list.add((Object)compound);
        }
        return list;
    }

    public static ListNBT nbtStringStringMap(HashMap<String, String> map) {
        ListNBT nbttaglist = new ListNBT();
        if (map == null) {
            return nbttaglist;
        }
        for (String slot : map.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("Slot", slot);
            nbttagcompound.func_74778_a("Value", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtStringIntegerMap(Map<String, Integer> map) {
        ListNBT nbttaglist = new ListNBT();
        if (map == null) {
            return nbttaglist;
        }
        for (String slot : map.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("Slot", slot);
            nbttagcompound.func_74768_a("Value", map.get(slot).intValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static INBT nbtIntegerStringMap(Map<Integer, String> map) {
        ListNBT nbttaglist = new ListNBT();
        if (map == null) {
            return nbttaglist;
        }
        for (int slot : map.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_74778_a("Value", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtStringArray(String[] list) {
        ListNBT nbttaglist = new ListNBT();
        if (list == null) {
            return nbttaglist;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("Value", list[i]);
            nbttagcompound.func_74768_a("Slot", i);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtStringList(List<String> list) {
        ListNBT nbttaglist = new ListNBT();
        for (String s : list) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("Line", s);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtResourceLocationList(List<ResourceLocation> list) {
        ListNBT nbttaglist = new ListNBT();
        for (ResourceLocation s : list) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74778_a("Line", s.toString());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListNBT nbtDoubleList(double ... par1ArrayOfDouble) {
        ListNBT nbttaglist = new ListNBT();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.add((Object)DoubleNBT.func_229684_a_((double)d1));
        }
        return nbttaglist;
    }

    public static CompoundNBT NBTMerge(CompoundNBT data, CompoundNBT merge) {
        CompoundNBT compound = data.func_74737_b();
        Set names = merge.func_150296_c();
        for (String name : names) {
            INBT base = merge.func_74781_a(name);
            if (base.func_74732_a() == 10) {
                base = NBTTags.NBTMerge(compound.func_74775_l(name), (CompoundNBT)base);
            }
            compound.func_218657_a(name, base);
        }
        return compound;
    }

    public static List<ScriptContainer> GetScript(ListNBT list, IScriptHandler handler) {
        ArrayList<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compoundd = list.func_150305_b(i);
            ScriptContainer script = new ScriptContainer(handler);
            script.load(compoundd);
            scripts.add(script);
        }
        return scripts;
    }

    public static ListNBT NBTScript(List<ScriptContainer> scripts) {
        ListNBT list = new ListNBT();
        for (ScriptContainer script : scripts) {
            CompoundNBT compound = new CompoundNBT();
            script.save(compound);
            list.add((Object)compound);
        }
        return list;
    }

    public static TreeMap<Long, String> GetLongStringMap(ListNBT tagList) {
        TreeMap<Long, String> list = new TreeMap<Long, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            list.put(nbttagcompound.func_74763_f("Long"), nbttagcompound.func_74779_i("String"));
        }
        return list;
    }

    public static ListNBT NBTLongStringMap(Map<Long, String> map) {
        ListNBT nbttaglist = new ListNBT();
        if (map == null) {
            return nbttaglist;
        }
        for (long slot : map.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74772_a("Long", slot);
            nbttagcompound.func_74778_a("String", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }
}

