/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiColoredLineWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemRendererWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextAreaWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;

public abstract class CustomGuiComponentWrapper
implements ICustomGuiComponent {
    int id;
    int posX;
    int posY;
    List<TranslationTextComponent> hoverText = new ArrayList<TranslationTextComponent>();

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public ICustomGuiComponent setID(int id) {
        this.id = id;
        return this;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public ICustomGuiComponent setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    @Override
    public boolean hasHoverText() {
        return this.hoverText.size() > 0;
    }

    @Override
    public String[] getHoverText() {
        String[] ht = new String[this.hoverText.size()];
        for (int i = 0; i < this.hoverText.size(); ++i) {
            ht[i] = this.hoverText.get(i).func_150268_i();
        }
        return ht;
    }

    public List<TranslationTextComponent> getHoverTextList() {
        return this.hoverText;
    }

    @Override
    public ICustomGuiComponent setHoverText(String text) {
        this.hoverText = new ArrayList<TranslationTextComponent>();
        this.hoverText.add(new TranslationTextComponent(text));
        return this;
    }

    @Override
    public ICustomGuiComponent setHoverText(String[] text) {
        ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
        for (String s : text) {
            list.add(new TranslationTextComponent(s));
        }
        this.hoverText = list;
        return this;
    }

    public ICustomGuiComponent setHoverText(List<TranslationTextComponent> list) {
        this.hoverText = new ArrayList<TranslationTextComponent>();
        for (TranslationTextComponent obj : list) {
            if (obj instanceof TranslationTextComponent) {
                this.hoverText.add(obj);
                continue;
            }
            this.hoverText.add(new TranslationTextComponent(String.valueOf(obj)));
        }
        return this;
    }

    public abstract int getType();

    public CompoundNBT toNBT(CompoundNBT nbt) {
        nbt.func_74768_a("id", this.id);
        nbt.func_74783_a("pos", new int[]{this.posX, this.posY});
        if (this.hoverText != null) {
            ListNBT list = new ListNBT();
            for (TranslationTextComponent s : this.hoverText) {
                list.add((Object)StringNBT.func_229705_a_((String)s.func_150268_i()));
            }
            if (!list.isEmpty()) {
                nbt.func_218657_a("hover", (INBT)list);
            }
        }
        nbt.func_74768_a("type", this.getType());
        return nbt;
    }

    public CustomGuiComponentWrapper fromNBT(CompoundNBT nbt) {
        this.setID(nbt.func_74762_e("id"));
        this.setPos(nbt.func_74759_k("pos")[0], nbt.func_74759_k("pos")[1]);
        if (nbt.func_74764_b("hover")) {
            ListNBT list = nbt.func_150295_c("hover", 8);
            String[] hoverText = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                hoverText[i] = list.get(i).func_150285_a_();
            }
            this.setHoverText(hoverText);
        }
        return this;
    }

    public static CustomGuiComponentWrapper createFromNBT(CompoundNBT nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                return new CustomGuiButtonWrapper().fromNBT(nbt);
            }
            case 1: {
                return new CustomGuiLabelWrapper().fromNBT(nbt);
            }
            case 2: {
                return new CustomGuiTexturedRectWrapper().fromNBT(nbt);
            }
            case 3: {
                return new CustomGuiTextFieldWrapper().fromNBT(nbt);
            }
            case 4: {
                return new CustomGuiScrollWrapper().fromNBT(nbt);
            }
            case 5: {
                return new CustomGuiItemSlotWrapper().fromNBT(nbt);
            }
            case 6: {
                return new CustomGuiTextAreaWrapper().fromNBT(nbt);
            }
            case 7: {
                return new CustomGuiEntityDisplayWrapper().fromNBT(nbt);
            }
            case 8: {
                return new CustomGuiColoredLineWrapper().fromNBT(nbt);
            }
            case 9: {
                return new CustomGuiItemRendererWrapper().fromNBT(nbt);
            }
        }
        return null;
    }
}

