/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.gui.IEntityDisplay;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiEntityDisplayWrapper
extends CustomGuiComponentWrapper
implements IEntityDisplay {
    public int rotation;
    public boolean isFollowingCursor;
    public float scale;
    public IEntity entity;
    public INbt entityData = new NBTWrapper(new CompoundNBT());
    public int width;
    public int height;
    public int entityId;

    public CustomGuiEntityDisplayWrapper() {
    }

    public CustomGuiEntityDisplayWrapper(int id, int x, int y, int width, int height, IEntity entity) {
        this.entityId = -1;
        this.rotation = 0;
        this.scale = 1.0f;
        this.isFollowingCursor = false;
        this.setID(id);
        this.setEntity(entity);
        this.setPos(x, y);
        this.setHoverBox(width, height);
    }

    @Override
    public IEntity getEntity() {
        return this.entity;
    }

    @Override
    public IEntityDisplay setEntity(IEntity entity) {
        this.entity = entity;
        this.entityData = entity == null ? new NBTWrapper(new CompoundNBT()) : entity.getEntityNbt();
        if (entity.getMCEntity() instanceof PlayerEntity) {
            this.entityId = entity.getMCEntity().func_145782_y();
        }
        return this;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public IEntityDisplay setRotation(int deg) {
        this.rotation = deg;
        return this;
    }

    @Override
    public boolean isFollowingCursor() {
        return this.isFollowingCursor;
    }

    @Override
    public IEntityDisplay setFollowingCursor(boolean state) {
        this.isFollowingCursor = state;
        return this;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public IEntityDisplay setScale(float scaleFactor) {
        this.scale = scaleFactor;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IEntityDisplay setHoverBox(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public CompoundNBT toNBT(CompoundNBT compound) {
        super.toNBT(compound);
        compound.func_218657_a("entity", (INBT)this.entityData.getMCNBT());
        compound.func_74768_a("rotation", this.rotation);
        compound.func_74776_a("scale", this.scale);
        compound.func_74757_a("followCursor", this.isFollowingCursor);
        compound.func_74768_a("entityId", this.entityId);
        compound.func_74768_a("width", this.width);
        compound.func_74768_a("height", this.height);
        return compound;
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(CompoundNBT compound) {
        super.fromNBT(compound);
        this.entityData = NpcAPI.Instance().getINbt(compound.func_74775_l("entity"));
        this.setRotation(compound.func_74762_e("rotation"));
        this.setScale(compound.func_74760_g("scale"));
        this.isFollowingCursor = compound.func_74767_n("followCursor");
        this.entityId = compound.func_74762_e("entityId");
        this.setHoverBox(compound.func_74762_e("width"), compound.func_74762_e("height"));
        return this;
    }
}

