/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.IItemRenderer;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiItemRendererWrapper
extends CustomGuiComponentWrapper
implements IItemRenderer {
    IItemStack stack;
    public int width;
    public int height;
    public float scale;

    public CustomGuiItemRendererWrapper() {
        this.stack = ItemStackWrapper.AIR;
    }

    public CustomGuiItemRendererWrapper(int id, int x, int y, int width, int height, IItemStack stack) {
        this.id = id;
        this.stack = ItemStackWrapper.AIR;
        this.scale = 1.0f;
        this.setPos(x, y);
        this.setStack(stack);
        this.setHoverBox(width, height);
    }

    @Override
    public boolean hasStack() {
        return !this.stack.isEmpty();
    }

    @Override
    public IItemStack getStack() {
        return this.stack;
    }

    @Override
    public IItemRenderer setStack(IItemStack itemStack) {
        this.stack = itemStack == null ? ItemStackWrapper.AIR : itemStack;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IItemRenderer setHoverBox(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public IItemRenderer setScale(float scaleFactor) {
        this.scale = scaleFactor;
        return this;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public CompoundNBT toNBT(CompoundNBT nbt) {
        super.toNBT(nbt);
        nbt.func_218657_a("stack", (INBT)this.stack.getMCItemStack().serializeNBT());
        nbt.func_74776_a("scale", this.scale);
        nbt.func_74768_a("width", this.width);
        nbt.func_74768_a("height", this.height);
        return nbt;
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(CompoundNBT nbt) {
        super.fromNBT(nbt);
        this.setStack(NpcAPI.Instance().getIItemStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack"))));
        this.setScale(nbt.func_74760_g("scale"));
        this.setHoverBox(nbt.func_74762_e("width"), nbt.func_74762_e("height"));
        return this;
    }
}

