/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.CompoundNBT;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiTexturedRectWrapper
extends CustomGuiComponentWrapper
implements ITexturedRect {
    int width;
    int height;
    int textureX;
    int textureY = -1;
    float scale = 1.0f;
    String texture;

    public CustomGuiTexturedRectWrapper() {
    }

    public CustomGuiTexturedRectWrapper(int id, String texture, int x, int y, int width, int height) {
        this.setID(id);
        this.setTexture(texture);
        this.setPos(x, y);
        this.setSize(width, height);
    }

    public CustomGuiTexturedRectWrapper(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        this(id, texture, x, y, width, height);
        this.setTextureOffset(textureX, textureY);
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public ITexturedRect setTexture(String texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ITexturedRect setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public ITexturedRect setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public int getTextureX() {
        return this.textureX;
    }

    @Override
    public int getTextureY() {
        return this.textureY;
    }

    @Override
    public ITexturedRect setTextureOffset(int offsetX, int offsetY) {
        this.textureX = offsetX;
        this.textureY = offsetY;
        return this;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public CompoundNBT toNBT(CompoundNBT compound) {
        super.toNBT(compound);
        compound.func_74783_a("size", new int[]{this.width, this.height});
        compound.func_74776_a("scale", this.scale);
        compound.func_74778_a("texture", this.texture);
        if (this.textureX >= 0 && this.textureY >= 0) {
            compound.func_74783_a("texPos", new int[]{this.textureX, this.textureY});
        }
        return compound;
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(CompoundNBT compound) {
        super.fromNBT(compound);
        this.setSize(compound.func_74759_k("size")[0], compound.func_74759_k("size")[1]);
        this.setScale(compound.func_74760_g("scale"));
        this.setTexture(compound.func_74779_i("texture"));
        if (compound.func_74764_b("texPos")) {
            this.setTextureOffset(compound.func_74759_k("texPos")[0], compound.func_74759_k("texPos")[1]);
        }
        return this;
    }
}

