/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.CustomBlocks;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestLocation;

public class TileWaypoint
extends TileNpcEntity
implements ITickableTileEntity {
    public String name = "";
    private int ticks = 10;
    private List<PlayerEntity> recentlyChecked = new ArrayList<PlayerEntity>();
    private List<PlayerEntity> toCheck;
    public int range = 10;

    public TileWaypoint() {
        super(CustomBlocks.tile_waypoint);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.name.isEmpty()) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 10;
        this.toCheck = this.getPlayerList(this.range, this.range, this.range);
        this.toCheck.removeAll(this.recentlyChecked);
        List<PlayerEntity> listMax = this.getPlayerList(this.range + 10, this.range + 10, this.range + 10);
        this.recentlyChecked.retainAll(listMax);
        this.recentlyChecked.addAll(this.toCheck);
        if (this.toCheck.isEmpty()) {
            return;
        }
        for (PlayerEntity player : this.toCheck) {
            PlayerData pdata = PlayerData.get(player);
            PlayerQuestData playerdata = pdata.questData;
            for (QuestData data : playerdata.activeQuests.values()) {
                QuestLocation quest;
                if (data.quest.type != 3 || !(quest = (QuestLocation)data.quest.questInterface).setFound(data, this.name)) continue;
                player.func_145747_a((ITextComponent)new TranslationTextComponent(this.name).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("quest.found")), Util.field_240973_b_);
                playerdata.checkQuestCompletion(player, 3);
                pdata.updateClient = true;
            }
        }
    }

    private List<PlayerEntity> getPlayerList(int x, int y, int z) {
        return this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)x, (double)y, (double)z));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.name = compound.func_74779_i("LocationName");
        this.range = compound.func_74762_e("LocationRange");
        if (this.range < 2) {
            this.range = 2;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (!this.name.isEmpty()) {
            compound.func_74778_a("LocationName", this.name);
        }
        compound.func_74768_a("LocationRange", this.range);
        return super.func_189515_b(compound);
    }
}

