/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiQuestLog;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerKeyPressed;
import noppes.npcs.packets.server.SPacketPlayerLeftClicked;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.packets.server.SPacketSceneReset;
import noppes.npcs.packets.server.SPacketSceneStart;

public class ClientTickHandler {
    private World prevWorld;
    private boolean otherContainer = false;
    private final int[] ignoreKeys = new int[]{341, 340, 342, 343, 345, 344, 346, 347};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof PlayerContainer) {
            if (this.otherContainer) {
                Packets.sendServer(new SPacketQuestCompletionCheckAll());
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        ++CustomNpcs.ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (this.prevWorld != mc.field_71441_e) {
            this.prevWorld = mc.field_71441_e;
            MusicController.Instance.stopMusic();
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.func_147114_u() == null) {
            return;
        }
        if (CustomNpcs.SceneButtonsEnabled) {
            if (ClientProxy.Scene1.func_151470_d()) {
                Packets.sendServer(new SPacketSceneStart(1));
            }
            if (ClientProxy.Scene2.func_151470_d()) {
                Packets.sendServer(new SPacketSceneStart(2));
            }
            if (ClientProxy.Scene3.func_151470_d()) {
                Packets.sendServer(new SPacketSceneStart(3));
            }
            if (ClientProxy.SceneReset.func_151470_d()) {
                Packets.sendServer(new SPacketSceneReset());
            }
        }
        if (ClientProxy.QuestLog.func_151470_d()) {
            if (mc.field_71462_r == null) {
                NoppesUtil.openGUI((PlayerEntity)mc.field_71439_g, new GuiQuestLog((PlayerEntity)mc.field_71439_g));
            } else if (mc.field_71462_r instanceof GuiQuestLog) {
                mc.field_71417_B.func_198034_i();
            }
        }
        if (event.getAction() == 1 || event.getAction() == 0) {
            boolean isCtrlPressed = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)345);
            boolean isShiftPressed = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
            boolean isAltPressed = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)342) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)346);
            boolean isMetaPressed = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)343) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)347);
            String openGui = mc.field_71462_r == null ? "" : mc.field_71462_r.getClass().getName();
            Packets.sendServer(new SPacketPlayerKeyPressed(event.getKey(), isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, event.getAction() == 0, openGui));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        Packets.sendServer(new SPacketPlayerLeftClicked());
    }

    private boolean isIgnoredKey(int key) {
        for (int i : this.ignoreKeys) {
            if (i != key) continue;
            return true;
        }
        return false;
    }
}

