/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.api.overlay.ILabel;
import noppes.npcs.api.overlay.IOverlay;
import noppes.npcs.api.overlay.IOverlayComponent;
import noppes.npcs.api.overlay.IRenderItemOverlay;
import noppes.npcs.api.overlay.ITexturedRect;
import noppes.npcs.client.RenderUtils;
import noppes.npcs.shared.client.gui.components.GuiBasic;

public class OverlayController
extends GuiBasic {
    private static final OverlayController instance = new OverlayController();
    private final Int2ObjectOpenHashMap<Overlay> overlays = new Int2ObjectOpenHashMap();

    public static OverlayController getInstance() {
        return instance;
    }

    public void addOverlay(IOverlay overlay) {
        this.overlays.put(overlay.getId(), (Object)new Overlay(overlay));
    }

    public void removeOverlay(int id) {
        this.overlays.remove(id);
    }

    public void clear() {
        this.overlays.clear();
    }

    public void renderOverlays(MatrixStack matrixStack) {
        for (Overlay overlay : this.overlays.values()) {
            overlay.render(matrixStack);
        }
    }

    static interface IOverlayRenderComponent {
        public void render(MatrixStack var1, int var2);
    }

    public static class TexturedRect
    implements IOverlayRenderComponent {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final String texture;
        private final int textureX;
        private final int textureY;
        private final int textureMaxX;
        private final int textureMaxY;
        private final int id;

        public TexturedRect(ITexturedRect component) {
            this.x = component.getPosX();
            this.y = component.getPosY();
            this.id = component.getId();
            this.width = component.getWidth();
            this.height = component.getHeight();
            this.texture = component.getTexture();
            this.textureX = component.getTextureX();
            this.textureY = component.getTextureY();
            this.textureMaxX = component.getTextureMaxX();
            this.textureMaxY = component.getTextureMaxY();
        }

        @Override
        public void render(MatrixStack matrixStack, int linkSide) {
            int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o() - this.width;
            int height = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - this.height;
            int i = width / 2;
            if (Objects.equals(this.texture, "")) {
                RenderUtils.renderGradientRect(this.id, this.x, this.y, linkSide, width, height, this.width, this.height, i, -1072689136, -804253680);
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.texture));
                if (this.textureX >= 0 && this.textureY >= 0) {
                    if (this.textureMaxX >= 0 && this.textureMaxY >= 0) {
                        RenderUtils.renderRectTextureCustomSize(matrixStack, this.x, this.y, linkSide, width, height, this.width, this.height, i, this.textureX, this.textureY, this.textureMaxX, this.textureMaxY);
                    } else {
                        RenderUtils.renderRectTextureSize(matrixStack, this.x, this.y, linkSide, width, height, this.width, this.height, i, this.textureX, this.textureY);
                    }
                } else {
                    RenderUtils.renderRectTexture(matrixStack, this.x, this.y, linkSide, width, height, this.width, this.height, i);
                }
            }
        }
    }

    static class RenderItem
    implements IOverlayRenderComponent {
        private final int x;
        private final int y;
        private final int id;
        private final ItemStack item;
        protected ItemRenderer itemRender;

        RenderItem(IRenderItemOverlay item) {
            this.x = item.getPosX();
            this.y = item.getPosY();
            this.id = item.getId();
            this.item = item.getItem();
        }

        @Override
        public void render(MatrixStack matrixStack, int linkSide) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)this.x, (double)this.y, (double)this.id);
            matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
            int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o() - 16;
            int height = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 16;
            RenderSystem.enableRescaleNormal();
            this.itemRender = Minecraft.func_71410_x().func_175599_af();
            this.itemRender.field_77023_b = 100.0f;
            RenderUtils.renderItemOverlay(linkSide, this.itemRender, this.item, this.x, this.y, width, height);
            this.itemRender.field_77023_b = 0.0f;
            RenderSystem.disableRescaleNormal();
            matrixStack.func_227865_b_();
        }
    }

    static class Label
    implements IOverlayRenderComponent {
        private final String text;
        private final int x;
        private final int y;
        private final int id;
        private final float scale;

        Label(ILabel label) {
            String[] split;
            String text = label.getText();
            this.x = label.getPosX();
            this.y = label.getPosY();
            this.id = label.getId();
            this.scale = label.getScale();
            StringBuilder stringBuilder = new StringBuilder();
            String[] values = split = text.split("&t");
            for (String s : split) {
                if (I18n.func_188566_a((String)s)) {
                    stringBuilder.append(I18n.func_135052_a((String)s, (Object[])new Object[0]));
                    continue;
                }
                stringBuilder.append(s);
            }
            this.text = stringBuilder.toString();
        }

        @Override
        public void render(MatrixStack matrixStack, int linkSide) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)this.x, (double)this.y, (double)this.id);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            int height = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            List stringsList = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent(this.text), 1000);
            for (IReorderingProcessor s : stringsList) {
                RenderUtils.renderString(matrixStack, this.text, this.x, this.y, linkSide, width, height, s);
            }
            matrixStack.func_227865_b_();
        }
    }

    static class Overlay {
        private final Queue<IOverlayRenderComponent> components = new ArrayDeque<IOverlayRenderComponent>();
        private final int linkSide;

        Overlay(IOverlay overlay) {
            this.linkSide = overlay.getLinkSide();
            for (IOverlayComponent component : overlay.getComponents()) {
                if (component instanceof ILabel) {
                    this.components.add(new Label((ILabel)component));
                    continue;
                }
                if (component instanceof IRenderItemOverlay) {
                    this.components.add(new RenderItem((IRenderItemOverlay)component));
                    continue;
                }
                if (!(component instanceof ITexturedRect)) continue;
                this.components.add(new TexturedRect((ITexturedRect)component));
            }
        }

        void render(MatrixStack matrixStack) {
            matrixStack.func_227860_a_();
            for (IOverlayRenderComponent component : this.components) {
                component.render(matrixStack, this.linkSide);
            }
            matrixStack.func_227865_b_();
        }
    }
}

