/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.shared.common.util.LogWriter;
import org.apache.commons.compress.utils.IOUtils;

public class SkinUtil {
    private static final HashSet<ResourceLocation> createdSkins = new HashSet();

    public static ResourceLocation createPlayerSkin(PlayerSkinData skin) {
        LogWriter.debug("Check skin: " + skin);
        if (createdSkins.contains(skin.getResLoc())) {
            return skin.getResLoc();
        }
        String locSkin = String.format("assets/%s/%s", skin.getResLoc().func_110624_b(), skin.getResLoc().func_110623_a());
        File file = new File(CustomNpcs.Dir, locSkin);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && file.isFile()) {
            return null;
        }
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
        ArrayList listBuffers = Lists.newArrayList();
        BufferedImage bodyImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "torsos", skin.getBody()));
        bodyImage = SkinUtil.colorTexture(bodyImage, new Color(skin.getBodyColor()));
        BufferedImage hairImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "hairs", skin.getHair()));
        hairImage = SkinUtil.colorTexture(hairImage, new Color(skin.getHairColor()));
        BufferedImage faceImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "faces", skin.getFace()));
        faceImage = SkinUtil.colorTexture(faceImage, new Color(skin.getEyesColor()));
        BufferedImage legsImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "legs", skin.getLeg()));
        BufferedImage jacketsImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "jackets", skin.getJacket()));
        BufferedImage shoesImage = SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "shoes", skin.getShoes()));
        for (int pec : skin.getPeculiarities()) {
            listBuffers.add(SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "peculiarities", pec)));
        }
        BufferedImage skinImage = SkinUtil.combineTextures(bodyImage, SkinUtil.readBufferedImage(rm, skin.getPartResLocByNumber(tm, "torsos", -1)));
        skinImage = SkinUtil.combineTextures(skinImage, faceImage);
        skinImage = SkinUtil.combineTextures(skinImage, legsImage);
        skinImage = SkinUtil.combineTextures(skinImage, shoesImage);
        skinImage = SkinUtil.combineTextures(skinImage, jacketsImage);
        skinImage = SkinUtil.combineTextures(skinImage, faceImage);
        skinImage = SkinUtil.combineTextures(skinImage, hairImage);
        if (!listBuffers.isEmpty()) {
            for (BufferedImage buffer : listBuffers) {
                skinImage = SkinUtil.combineTextures(skinImage, buffer);
            }
        }
        try {
            ImageIO.write((RenderedImage)skinImage, "PNG", file);
            tm.func_110577_a(skin.getResLoc());
            LogWriter.debug("Create new player skin: " + file.getAbsolutePath());
        }
        catch (Exception pec) {
            // empty catch block
        }
        SimpleTexture texture = new SimpleTexture(skin.getResLoc());
        TextureUtil.func_225680_a_((int)texture.func_110552_b(), (int)skinImage.getWidth(), (int)skinImage.getHeight());
        SkinUtil.uploadBufferedImageContents(skinImage, texture.func_110552_b());
        tm.func_229263_a_(skin.getResLoc(), (Texture)texture);
        createdSkins.add(skin.getResLoc());
        return skin.getResLoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readBufferedImage(IResourceManager rm, ResourceLocation resLoc) {
        BufferedImage bufferedImage;
        if (resLoc == null) {
            return null;
        }
        InputStream imageStream = null;
        try {
            imageStream = rm.func_199002_a(resLoc).func_199027_b();
            bufferedImage = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            BufferedImage bufferedImage2;
            try {
                bufferedImage2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(imageStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)imageStream);
            return bufferedImage2;
        }
        IOUtils.closeQuietly((Closeable)imageStream);
        return bufferedImage;
    }

    private static void uploadBufferedImageContents(BufferedImage bufferedimage, int id) {
        int j = bufferedimage.getWidth();
        int k = bufferedimage.getHeight();
        int[] lvt_8_1_ = new int[j * k];
        bufferedimage.getRGB(0, 0, j, k, lvt_8_1_, 0, j);
        IntBuffer intbuffer = ByteBuffer.allocateDirect(4 * j * k).order(ByteOrder.nativeOrder()).asIntBuffer();
        intbuffer.put(lvt_8_1_);
        intbuffer.flip();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)id);
        TextureUtil.func_225685_a_((IntBuffer)intbuffer, (int)j, (int)k);
    }

    private static BufferedImage colorTexture(BufferedImage buffer, Color color) {
        if (buffer == null || color == null) {
            return buffer;
        }
        for (int v = 0; v < buffer.getHeight(); ++v) {
            for (int u = 0; u < buffer.getWidth(); ++u) {
                String b;
                String g;
                String r;
                int c = buffer.getRGB(u, v);
                int al = c >> 24 & 0xFF;
                if (al == 0) continue;
                int r0 = c >> 16 & 0xFF;
                int g0 = c >> 8 & 0xFF;
                int b0 = c & 0xFF;
                String a = Integer.toHexString(Math.min(al + color.getAlpha(), 255));
                if (a.length() == 1) {
                    a = "0" + a;
                }
                if ((r = Integer.toHexString((r0 + color.getRed()) / 2)).length() == 1) {
                    r = "0" + r;
                }
                if ((g = Integer.toHexString((g0 + color.getGreen()) / 2)).length() == 1) {
                    g = "0" + g;
                }
                if ((b = Integer.toHexString((b0 + color.getBlue()) / 2)).length() == 1) {
                    b = "0" + b;
                }
                buffer.setRGB(u, v, (int)Long.parseLong(a + r + g + b, 16));
            }
        }
        return buffer;
    }

    private static BufferedImage combineTextures(BufferedImage buffer_0, BufferedImage buffer_1) {
        if (buffer_0 == null) {
            return buffer_1;
        }
        if (buffer_1 == null) {
            return buffer_0;
        }
        int w0 = buffer_0.getWidth();
        int w1 = buffer_1.getWidth();
        int h0 = buffer_0.getHeight();
        int h1 = buffer_1.getHeight();
        int w = Math.max(w0, w1);
        int h = Math.max(h0, h1);
        float sw0 = (float)w0 / (float)w;
        float sh0 = (float)h0 / (float)h;
        float sw1 = (float)w1 / (float)w;
        float sh1 = (float)h1 / (float)h;
        BufferedImage total = new BufferedImage(w, h, 6);
        for (int v = 0; v < h; ++v) {
            for (int u = 0; u < w; ++u) {
                String b;
                String g;
                String r;
                int c1;
                int a1;
                int c0 = buffer_0.getRGB((int)((float)u * sw0), (int)((float)v * sh0));
                int a0 = c0 >> 24 & 0xFF;
                if (a0 != 0) {
                    total.setRGB(u, v, c0);
                }
                if ((a1 = (c1 = buffer_1.getRGB((int)((float)u * sw1), (int)((float)v * sh1))) >> 24 & 0xFF) == 0) continue;
                if (a1 == 255) {
                    total.setRGB(u, v, c1);
                    continue;
                }
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                int r1 = c1 >> 16 & 0xFF;
                int g1 = c1 >> 8 & 0xFF;
                int b1 = c1 & 0xFF;
                String a = Integer.toHexString(Math.min(a0 + a1, 255));
                if (a.length() == 1) {
                    a = "0" + a;
                }
                if ((r = Integer.toHexString((r0 + r1) / 2)).length() == 1) {
                    r = "0" + r;
                }
                if ((g = Integer.toHexString((g0 + g1) / 2)).length() == 1) {
                    g = "0" + g;
                }
                if ((b = Integer.toHexString((b0 + b1) / 2)).length() == 1) {
                    b = "0" + b;
                }
                total.setRGB(u, v, (int)Long.parseLong(a + r + g + b, 16));
            }
        }
        return total;
    }
}

