/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.moderngui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.moderngui.GuiQuestModern;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MouseHelperMixin;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogSelected;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.shared.client.gui.listeners.IGuiClose;

public class GuiDialogModern
extends GuiNPCInterface
implements IGuiClose {
    private Dialog dialog;
    private int selected = -1;
    private List<Integer> options = new ArrayList<Integer>();
    private final ResourceLocation decomposed = new ResourceLocation("customnpcs", "textures/gui/dialog_menu_decomposed.png");
    private boolean isGrabbed = false;

    public GuiDialogModern(EntityNPCInterface npc, Dialog dialog) {
        super(npc);
        this.dialog = dialog;
        this.appendDialog(dialog);
        this.imageHeight = 238;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.isGrabbed = false;
        this.grabMouse(this.dialog.showWheel);
        this.guiTop = this.field_230709_l_ - this.imageHeight;
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            MouseHelperMixin mouse = (MouseHelperMixin)Minecraft.func_71410_x().field_71417_B;
            mouse.setGrabbed(false);
            double xpos = 0.0;
            double ypos = 0.0;
            mouse.setX(xpos);
            mouse.setY(ypos);
            InputMappings.func_216504_a((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)212995, (double)xpos, (double)ypos);
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_198032_j();
            this.isGrabbed = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66000000, 0x66000000);
        double wcoeff = (double)this.field_230708_k_ / 960.0;
        double hcoeff = (double)this.field_230709_l_ / 509.0;
        if (!this.dialog.hideNPC && !(this.npc instanceof EntityDialogNpc)) {
            this.drawNpc((LivingEntity)this.npc, -210 + (int)(300.0 * (1.0 - wcoeff)), 350 - (int)(100.0 * (1.0 - hcoeff)), (float)(9.5 * hcoeff), -20);
        }
        int textBlockWidth = (int)(700.0 * wcoeff);
        int lineCount = this.getLineCount(this.dialog.text, textBlockWidth);
        int gap = Math.max(16, Math.min((int)(2.6f * (float)lineCount), 32));
        int textPartHeight = 26 + lineCount * ClientProxy.Font.height(null) + 2 * gap;
        this.func_238468_a_(matrixStack, 0, this.field_230709_l_ - textPartHeight, this.field_230708_k_, this.field_230709_l_, -1157627904, -1157627904);
        this.drawLine(matrixStack, 23, this.field_230709_l_ - textPartHeight + 23, this.field_230708_k_ - 23);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.5, (double)200.065f);
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.0f);
        AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.npc.func_145748_c_(), (int)31, (int)((int)((double)(this.field_230709_l_ - textPartHeight + 5) / 1.5)), (int)-1);
        matrixStack.func_227862_a_(0.6666667f, 0.6666667f, 1.0f);
        this.drawTextBlock(matrixStack, this.dialog.text, (this.field_230708_k_ - textBlockWidth) / 2, this.field_230709_l_ - textPartHeight + 23 + 3 + gap, textBlockWidth);
        this.selected = -1;
        matrixStack.func_227862_a_((float)wcoeff, (float)wcoeff, (float)wcoeff);
        for (int i = 0; i < this.options.size(); ++i) {
            int optionHeight = (int)(220.0 * hcoeff + (double)(i * 19));
            int optionNum = this.options.get(i);
            DialogOption option = this.dialog.options.get(optionNum);
            if ((double)mouseX >= 723.0 * wcoeff && (double)mouseX <= 946.0 * wcoeff && (double)mouseY >= (double)optionHeight * wcoeff && (double)mouseY <= (double)(optionHeight + 13) * wcoeff) {
                this.selected = i;
            }
            RenderSystem.enableBlend();
            this.field_230706_i_.func_110434_K().func_110577_a(this.decomposed);
            this.func_238474_b_(matrixStack, 723, optionHeight, 0, i == this.selected ? 13 : 0, 223, 13);
            RenderSystem.disableBlend();
            if (this.getQuestByOptionId(optionNum) != null) {
                GuiDialogModern.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"!", (int)727, (int)(optionHeight + 3), (int)7792731);
            } else {
                GuiDialogModern.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)">", (int)727, (int)(optionHeight + 3), (int)-1);
            }
            GuiDialogModern.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)735, (int)(optionHeight + 3), (int)option.optionColor);
        }
        matrixStack.func_227865_b_();
    }

    public Quest getQuestByOptionId(int id) {
        DialogOption option = this.dialog.options.get(id);
        if (option != null && option.getDialog() != null && option.getDialog().hasQuest()) {
            return option.getDialog().getQuest();
        }
        return null;
    }

    public void drawLine(MatrixStack stack, int x, int y, int width) {
        GuiDialogModern.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)width, (int)(y + 1), (int)-7522304);
        GuiDialogModern.func_238467_a_((MatrixStack)stack, (int)x, (int)(y + 1), (int)width, (int)(y + 2), (int)-88773);
        GuiDialogModern.func_238467_a_((MatrixStack)stack, (int)x, (int)(y + 2), (int)width, (int)(y + 3), (int)-5352703);
    }

    @Override
    public void drawNpc(LivingEntity entity, int x, int y, float zoomed, int rotation) {
        EntityCustomNpc npc = null;
        if (entity instanceof EntityCustomNpc) {
            npc = (EntityCustomNpc)entity;
        }
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        float scale = 1.0f;
        if ((double)entity.func_213302_cg() > 2.4) {
            scale = 2.0f / entity.func_213302_cg();
        }
        float f7 = this.guiLeft + x;
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = (float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation;
        entity.field_70125_A = 0.0f;
        entity.field_70759_as = 0.0f;
        entity.field_70758_at = 0.0f;
        int orientation = 0;
        int showName = 0;
        if (npc != null) {
            showName = npc.display.getShowName();
            npc.display.setShowName(1);
            orientation = npc.ais.orientation;
            npc.ais.orientation = rotation;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)this.guiLeft + (float)x), (float)(this.guiTop + y), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_(30.0f * scale * zoomed, 30.0f * scale * zoomed, 30.0f * scale * zoomed);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        EntityRendererManager lvt_16_1_ = Minecraft.func_71410_x().func_175598_ae();
        lvt_16_1_.func_178633_a(false);
        IRenderTypeBuffer.Impl lvt_17_1_ = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)rotation));
        RenderSystem.runAsFancy(() -> lvt_16_1_.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)lvt_17_1_, 0xF000F0));
        lvt_17_1_.func_228461_a_();
        lvt_16_1_.func_178633_a(true);
        RenderSystem.popMatrix();
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        if (npc != null) {
            npc.display.setShowName(showName);
            npc.ais.orientation = orientation;
        }
    }

    public void func_238651_a_(MatrixStack matrixStack, int p_238651_2_) {
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66000000, 0x66000000);
    }

    @Override
    public boolean func_231046_a_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if ((key == InputMappings.func_197955_a((String)"key.keyboard.enter").func_197937_c() || key == InputMappings.func_197955_a((String)"key.keyboard.keypad.enter").func_197937_c()) && (this.selected == -1 && this.options.isEmpty() || this.selected >= 0)) {
            this.handleDialogSelection();
        }
        if (this.closeOnEsc && (key == InputMappings.func_197955_a((String)"key.keyboard.escape").func_197937_c() || this.isInventoryKey(key))) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, -1));
            this.closed();
            this.func_231175_as__();
        }
        return true;
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        if ((this.selected == -1 && this.options.isEmpty() || this.selected >= 0) && k == 0) {
            this.handleDialogSelection();
        }
        return true;
    }

    private void handleDialogSelection() {
        int optionId = -1;
        if (this.dialog.showWheel) {
            optionId = this.selected;
        } else if (!this.options.isEmpty()) {
            optionId = this.options.get(this.selected);
        }
        if (this.getQuestByOptionId(optionId) == null) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, optionId));
        } else {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiQuestModern(this.npc, this.getQuestByOptionId(optionId), this.dialog, optionId));
        }
        if (this.dialog != null && this.dialog.hasOtherOptions() && !this.options.isEmpty()) {
            DialogOption option = this.dialog.options.get(optionId);
            if (option != null && option.optionType == 1) {
                NoppesUtil.clickSound();
            } else if (this.closeOnEsc) {
                this.closed();
                this.func_231175_as__();
            }
        } else if (this.closeOnEsc) {
            this.closed();
            this.func_231175_as__();
        }
    }

    private void closed() {
        this.grabMouse(false);
        Packets.sendServer(new SPacketQuestCompletionCheckAll());
    }

    public void drawTextBlock(MatrixStack stack, String text, int x, int y, int width) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        int count = 0;
        for (ITextComponent line : block.lines) {
            int height = y + count * ClientProxy.Font.height(null);
            AbstractGui.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)line, (int)(x + width / 2), (int)height, (int)-1);
            ++count;
        }
    }

    public int getLineCount(String text, int width) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        return block.lines.size();
    }

    public void appendDialog(Dialog dialog) {
        this.closeOnEsc = !dialog.disableEsc;
        this.dialog = dialog;
        this.options = new ArrayList<Integer>();
        if (dialog.sound != null && !dialog.sound.isEmpty()) {
            MusicController.Instance.stopMusic();
            BlockPos pos = this.npc.func_233580_cy_();
            MusicController.Instance.playSound(SoundCategory.VOICE, dialog.sound, pos, 1.0f, 1.0f);
        }
        for (int slot : dialog.options.keySet()) {
            DialogOption option = dialog.options.get(slot);
            if (option == null || !option.isAvailable((PlayerEntity)this.player)) continue;
            this.options.add(slot);
        }
        this.grabMouse(dialog.showWheel);
    }

    @Override
    public void setClose(CompoundNBT data) {
        this.grabMouse(false);
    }
}

