/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketNpcJobSave;
import noppes.npcs.roles.JobPuppet;
import noppes.npcs.shared.client.gui.components.GuiButtonBiDirectional;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScroll;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.components.GuiSliderNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.gui.listeners.ISliderListener;

public class GuiNpcPuppet
extends GuiNPCInterface
implements ISliderListener,
ICustomScrollListener {
    private Screen parent;
    private JobPuppet job;
    private String selectedName;
    private boolean isStart = true;
    public HashMap<String, JobPuppet.PartConfig> data = new HashMap();
    private GuiCustomScroll scroll;

    public GuiNpcPuppet(Screen parent, EntityCustomNpc npc) {
        super(npc);
        this.parent = parent;
        this.imageHeight = 230;
        this.imageWidth = 400;
        this.job = (JobPuppet)npc.job;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int y = this.guiTop;
        this.addButton(new GuiButtonNop((IGuiInterface)this, 30, this.guiLeft + 110, y += 14, 60, 20, new String[]{"gui.yes", "gui.no"}, this.job.whileStanding ? 0 : 1));
        this.addLabel(new GuiLabel(30, "puppet.standing", this.guiLeft + 10, y + 5, 0xFFFFFF));
        this.addButton(new GuiButtonNop((IGuiInterface)this, 31, this.guiLeft + 110, y += 22, 60, 20, new String[]{"gui.yes", "gui.no"}, this.job.whileMoving ? 0 : 1));
        this.addLabel(new GuiLabel(31, "puppet.walking", this.guiLeft + 10, y + 5, 0xFFFFFF));
        this.addButton(new GuiButtonNop((IGuiInterface)this, 32, this.guiLeft + 110, y += 22, 60, 20, new String[]{"gui.yes", "gui.no"}, this.job.whileAttacking ? 0 : 1));
        this.addLabel(new GuiLabel(32, "puppet.attacking", this.guiLeft + 10, y + 5, 0xFFFFFF));
        this.addButton(new GuiButtonNop((IGuiInterface)this, 33, this.guiLeft + 110, y += 22, 60, 20, new String[]{"gui.yes", "gui.no"}, this.job.animate ? 0 : 1));
        this.addLabel(new GuiLabel(33, "puppet.animation", this.guiLeft + 10, y + 5, 0xFFFFFF));
        if (this.job.animate) {
            this.addButton(new GuiButtonBiDirectional((IGuiInterface)this, 34, this.guiLeft + 240, y, 60, 20, new String[]{"1", "2", "3", "4", "5", "6", "7", "8"}, this.job.animationSpeed));
            this.addLabel(new GuiLabel(34, "stats.speed", this.guiLeft + 190, y + 5, 0xFFFFFF));
        }
        y += 34;
        HashMap<String, JobPuppet.PartConfig> data = new HashMap<String, JobPuppet.PartConfig>();
        if (this.isStart) {
            data.put("model.head", this.job.head);
            data.put("model.body", this.job.body);
            data.put("model.larm", this.job.larm);
            data.put("model.rarm", this.job.rarm);
            data.put("model.lleg", this.job.lleg);
            data.put("model.rleg", this.job.rleg);
        } else {
            data.put("model.head", this.job.head2);
            data.put("model.body", this.job.body2);
            data.put("model.larm", this.job.larm2);
            data.put("model.rarm", this.job.rarm2);
            data.put("model.lleg", this.job.lleg2);
            data.put("model.rleg", this.job.rleg2);
        }
        this.data = data;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
        }
        this.scroll.setList(new ArrayList<String>(data.keySet()));
        this.scroll.guiLeft = this.guiLeft + 10;
        this.scroll.guiTop = y;
        this.scroll.func_231149_a_(80, 100);
        this.addScroll(this.scroll);
        if (this.selectedName != null) {
            this.scroll.setSelected(this.selectedName);
            this.drawSlider(y, (JobPuppet.PartConfig)data.get(this.selectedName));
        }
        this.addButton(new GuiButtonNop(this, 66, this.guiLeft + this.imageWidth - 22, this.guiTop, 20, 20, "X"));
        if (this.job.animate) {
            this.addButton(new GuiButtonNop(this, 67, this.guiLeft + 10, y + 110, 70, 20, "gui.start"));
            this.addButton(new GuiButtonNop(this, 68, this.guiLeft + 90, y + 110, 70, 20, "gui.end"));
            this.getButton((int)67).field_230693_o_ = !this.isStart;
            this.getButton((int)68).field_230693_o_ = this.isStart;
        }
    }

    private void drawSlider(int y, JobPuppet.PartConfig config) {
        this.addButton(new GuiButtonNop((IGuiInterface)this, 29, this.guiLeft + 140, y, 80, 20, new String[]{"gui.enabled", "gui.disabled"}, config.disabled ? 1 : 0));
        this.addLabel(new GuiLabel(10, "X", this.guiLeft + 100, (y += 22) + 5, 0xFFFFFF));
        this.addSlider(new GuiSliderNop(this, 10, this.guiLeft + 120, y, (config.rotationX + 1.0f) / 2.0f));
        this.addLabel(new GuiLabel(11, "Y", this.guiLeft + 100, (y += 22) + 5, 0xFFFFFF));
        this.addSlider(new GuiSliderNop(this, 11, this.guiLeft + 120, y, (config.rotationY + 1.0f) / 2.0f));
        this.addLabel(new GuiLabel(12, "Z", this.guiLeft + 100, (y += 22) + 5, 0xFFFFFF));
        this.addSlider(new GuiSliderNop(this, 12, this.guiLeft + 120, y, (config.rotationZ + 1.0f) / 2.0f));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawNpc(320, 200);
    }

    @Override
    public void buttonEvent(GuiButtonNop btn) {
        if (!(btn instanceof GuiButtonNop)) {
            return;
        }
        GuiButtonNop button = btn;
        if (btn.id == 29) {
            boolean bl = this.data.get((Object)this.selectedName).disabled = button.getValue() == 1;
        }
        if (btn.id == 30) {
            boolean bl = this.job.whileStanding = button.getValue() == 0;
        }
        if (btn.id == 31) {
            boolean bl = this.job.whileMoving = button.getValue() == 0;
        }
        if (btn.id == 32) {
            boolean bl = this.job.whileAttacking = button.getValue() == 0;
        }
        if (btn.id == 33) {
            this.job.animate = button.getValue() == 0;
            this.isStart = true;
            this.func_231160_c_();
        }
        if (btn.id == 34) {
            this.job.animationSpeed = button.getValue();
        }
        if (btn.id == 66) {
            this.close();
        }
        if (btn.id == 67) {
            this.isStart = true;
            this.func_231160_c_();
        }
        if (btn.id == 68) {
            this.isStart = false;
            this.func_231160_c_();
        }
    }

    @Override
    public void close() {
        this.field_230706_i_.func_147108_a(this.parent);
        Packets.sendServer(new SPacketNpcJobSave(this.job.save(new CompoundNBT())));
    }

    @Override
    public void mouseDragged(GuiSliderNop slider) {
        int percent = (int)(slider.sliderValue * 360.0f);
        slider.setString(percent + "%");
        JobPuppet.PartConfig part = this.data.get(this.selectedName);
        if (slider.id == 10) {
            part.rotationX = (slider.sliderValue - 0.5f) * 2.0f;
        }
        if (slider.id == 11) {
            part.rotationY = (slider.sliderValue - 0.5f) * 2.0f;
        }
        if (slider.id == 12) {
            part.rotationZ = (slider.sliderValue - 0.5f) * 2.0f;
        }
        this.npc.func_213323_x_();
    }

    @Override
    public void mousePressed(GuiSliderNop slider) {
    }

    @Override
    public void mouseReleased(GuiSliderNop slider) {
    }

    @Override
    public void save() {
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll guiCustomScroll) {
        this.selectedName = guiCustomScroll.getSelected();
        this.func_231160_c_();
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

