/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketMarkData;

public class MarkData
implements ICapabilityProvider {
    @CapabilityInject(value=MarkData.class)
    public static Capability<MarkData> MARKDATA_CAPABILITY = null;
    private static final String NBTKEY = "cnpcmarkdata";
    private static final ResourceLocation CAPKEY = new ResourceLocation("customnpcs", "markdata");
    private LivingEntity entity;
    private LazyOptional<MarkData> instance = LazyOptional.of(() -> this);
    public List<Mark> marks = new ArrayList<Mark>();
    private static MarkData backup = new MarkData();

    public void setNBT(CompoundNBT compound) {
        ArrayList<Mark> marks = new ArrayList<Mark>();
        ListNBT list = compound.func_150295_c("marks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            Mark m = new Mark();
            m.type = c.func_74762_e("type");
            m.color = c.func_74762_e("color");
            m.availability.load(c.func_74775_l("availability"));
            marks.add(m);
        }
        this.marks = marks;
    }

    public CompoundNBT getNBT() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Mark m : this.marks) {
            CompoundNBT c = new CompoundNBT();
            c.func_74768_a("type", m.type);
            c.func_74768_a("color", m.color);
            c.func_218657_a("availability", (INBT)m.availability.save(new CompoundNBT()));
            list.add((Object)c);
        }
        compound.func_218657_a("marks", (INBT)list);
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == MARKDATA_CAPABILITY) {
            return this.instance.cast();
        }
        return LazyOptional.empty();
    }

    public static void register(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CAPKEY, (ICapabilityProvider)new MarkData());
    }

    public void save() {
        this.entity.getPersistentData().func_218657_a(NBTKEY, (INBT)this.getNBT());
    }

    public IMark addMark(int type) {
        Mark m = new Mark();
        m.type = type;
        this.marks.add(m);
        if (!this.entity.field_70170_p.field_72995_K) {
            this.syncClients();
        }
        return m;
    }

    public IMark addMark(int type, int color) {
        Mark m = new Mark();
        m.type = type;
        m.color = color;
        this.marks.add(m);
        if (!this.entity.field_70170_p.field_72995_K) {
            this.syncClients();
        }
        return m;
    }

    public static MarkData get(LivingEntity entity) {
        MarkData data = (MarkData)entity.getCapability(MARKDATA_CAPABILITY, null).orElse((Object)backup);
        if (data.entity == null) {
            data.entity = entity;
            data.setNBT(entity.getPersistentData().func_74775_l(NBTKEY));
        }
        return data;
    }

    public void syncClients() {
        Packets.sendAll(new PacketMarkData(this.entity.func_145782_y(), this.getNBT()));
    }

    public class Mark
    implements IMark {
        public int type = 0;
        public Availability availability = new Availability();
        public int color = 16772433;

        @Override
        public IAvailability getAvailability() {
            return this.availability;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void update() {
            MarkData.this.syncClients();
        }
    }
}

