/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;

public class PlayerBankData {
    public HashMap<Integer, BankData> banks = new HashMap();

    public void loadNBTData(CompoundNBT compound) {
        HashMap<Integer, BankData> banks = new HashMap<Integer, BankData>();
        ListNBT list = compound.func_150295_c("BankData", 10);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbttagcompound = list.func_150305_b(i);
            BankData data = new BankData();
            data.readNBT(nbttagcompound);
            banks.put(data.bankId, data);
        }
        this.banks = banks;
    }

    public void saveNBTData(CompoundNBT playerData) {
        ListNBT list = new ListNBT();
        for (BankData data : this.banks.values()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            data.writeNBT(nbttagcompound);
            list.add((Object)nbttagcompound);
        }
        playerData.func_218657_a("BankData", (INBT)list);
    }

    public BankData getBank(int bankId) {
        return this.banks.get(bankId);
    }

    public BankData getBankOrDefault(int bankId) {
        BankData data = this.banks.get(bankId);
        if (data != null) {
            return data;
        }
        Bank bank = BankController.getInstance().getBank(bankId);
        return this.banks.get(bank.id);
    }

    public boolean hasBank(int bank) {
        return this.banks.containsKey(bank);
    }

    public void loadNew(int bank) {
        BankData data = new BankData();
        data.bankId = bank;
        this.banks.put(bank, data);
    }
}

