/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomTabs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;

public class ItemSoulstoneEmpty
extends Item {
    public ItemSoulstoneEmpty() {
        super(new Item.Properties().func_200917_a(64).func_200916_a(CustomTabs.tab));
    }

    public boolean store(LivingEntity entity, ItemStack stack, PlayerEntity player) {
        if (!this.hasPermission(entity, player) || entity instanceof PlayerEntity) {
            return false;
        }
        ItemStack stone = new ItemStack((IItemProvider)CustomItems.soulstoneFull);
        CompoundNBT compound = new CompoundNBT();
        if (!entity.func_184198_c(compound)) {
            return false;
        }
        ServerCloneController.Instance.cleanTags(compound);
        stone.func_77983_a("Entity", (INBT)compound);
        String name = entity.func_70022_Q();
        if (name == null) {
            name = "generic";
        }
        stone.func_77983_a("Name", (INBT)StringNBT.func_229705_a_((String)name));
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            stone.func_77983_a("DisplayName", (INBT)StringNBT.func_229705_a_((String)entity.func_200200_C_().getString()));
            if (npc.role.getType() == 6) {
                RoleCompanion role = (RoleCompanion)npc.role;
                stone.func_77983_a("ExtraText", (INBT)StringNBT.func_229705_a_((String)("companion.stage,: ," + role.stage.name)));
            }
        } else if (entity.func_145818_k_()) {
            stone.func_77983_a("DisplayName", (INBT)StringNBT.func_229705_a_((String)entity.func_200201_e().getString()));
        }
        NoppesUtilServer.GivePlayerItem((Entity)player, player, stone);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77979_a(1);
            if (stack.func_190916_E() <= 0) {
                player.field_71071_by.func_184437_d(stack);
            }
        }
        entity.field_70128_L = true;
        return true;
    }

    public boolean hasPermission(LivingEntity entity, PlayerEntity player) {
        if (NoppesUtilServer.isOp(player)) {
            return true;
        }
        if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.SOULSTONE_ALL)) {
            return true;
        }
        if (entity instanceof EntityNPCInterface) {
            RoleInterface role;
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.role.getType() == 6 && ((RoleCompanion)(role = (RoleCompanion)npc.role)).getOwner() == player) {
                return true;
            }
            if (npc.role.getType() == 2 && ((RoleFollower)(role = (RoleFollower)npc.role)).getOwner() == player) {
                return !((RoleFollower)role).refuseSoulStone;
            }
            return CustomNpcs.SoulStoneNPCs;
        }
        if (entity instanceof AnimalEntity) {
            return CustomNpcs.SoulStoneAnimals;
        }
        return false;
    }
}

