/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets;

import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.common.util.LogWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IPacketServer
implements IPacket<IServerPlayNetHandler> {
    private static final Logger LOGGER = LogManager.getLogger();
    public ServerPlayerEntity player;
    public EntityNPCInterface npc;

    public void handle(IServerPlayNetHandler handler) {
        this.enqueueWork(() -> {
            try {
                this.player = ((ServerPlayNetHandler)handler).field_147369_b;
                this.npc = NoppesUtilServer.getEditingNpc((PlayerEntity)this.player);
                if (this.requiresNpc() && this.npc == null) {
                    return;
                }
                if (this.getPermission() != null && !CustomNpcsPermissions.hasPermission((PlayerEntity)this.player, this.getPermission())) {
                    return;
                }
                if (!this.toolAllowed(this.player.field_71071_by.func_70448_g())) {
                    this.warn("tried to use custom npcs without a tool in hand, possibly a hacker");
                    return;
                }
                this.handle();
            }
            catch (Throwable e) {
                LogWriter.except(e);
                throw e;
            }
        });
    }

    public boolean requiresNpc() {
        return false;
    }

    public CustomNpcsPermissions.Permission getPermission() {
        return null;
    }

    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.wand;
    }

    public abstract void handle();

    private void warn(String warning) {
        LOGGER.warn(this.player.func_200200_C_().getString() + ": " + warning + " - " + this);
    }

    public CompletableFuture<Void> enqueueWork(Runnable runnable) {
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
        if (!executor.func_213162_bc()) {
            return executor.func_213165_a(runnable);
        }
        runnable.run();
        return CompletableFuture.completedFuture(null);
    }
}

