/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobChunkLoader
extends JobInterface {
    private List<ChunkPos> chunks = new ArrayList<ChunkPos>();
    private int ticks = 20;
    private long playerLastSeen = -1L;

    public JobChunkLoader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public CompoundNBT save(CompoundNBT compound) {
        compound.func_74772_a("ChunkPlayerLastSeen", this.playerLastSeen);
        return compound;
    }

    @Override
    public void load(CompoundNBT compound) {
        this.playerLastSeen = compound.func_74763_f("ChunkPlayerLastSeen");
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 20;
        List players = this.npc.field_70170_p.func_217357_a(PlayerEntity.class, this.npc.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0));
        if (!players.isEmpty()) {
            this.playerLastSeen = System.currentTimeMillis();
        }
        if (this.playerLastSeen < 0L) {
            return false;
        }
        if (System.currentTimeMillis() > this.playerLastSeen + 600000L) {
            ChunkController.instance.unload((ServerWorld)this.npc.field_70170_p, this.npc.func_110124_au(), this.npc.field_70176_ah, this.npc.field_70164_aj);
            this.chunks.clear();
            this.playerLastSeen = -1L;
            return false;
        }
        double x = this.npc.func_226277_ct_() / 16.0;
        double z = this.npc.func_226281_cx_() / 16.0;
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        list.add(new ChunkPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)z)));
        list.add(new ChunkPos(MathHelper.func_76143_f((double)x), MathHelper.func_76143_f((double)z)));
        list.add(new ChunkPos(MathHelper.func_76128_c((double)x), MathHelper.func_76143_f((double)z)));
        list.add(new ChunkPos(MathHelper.func_76143_f((double)x), MathHelper.func_76128_c((double)z)));
        for (ChunkPos chunk : list) {
            if (!this.chunks.contains(chunk)) {
                ChunkController.instance.load((ServerWorld)this.npc.field_70170_p, this.npc.func_110124_au(), chunk.field_77276_a, chunk.field_77275_b);
            }
            this.chunks.remove(chunk);
        }
        for (ChunkPos chunk : this.chunks) {
            ChunkController.instance.unload((ServerWorld)this.npc.field_70170_p, this.npc.func_110124_au(), chunk.field_77276_a, chunk.field_77275_b);
        }
        this.chunks = list;
        return false;
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void reset() {
        if (this.npc.field_70170_p instanceof ServerWorld) {
            ChunkController.instance.unload((ServerWorld)this.npc.field_70170_p, this.npc.func_110124_au(), this.npc.field_70176_ah, this.npc.field_70164_aj);
            this.chunks.clear();
            this.playerLastSeen = 0L;
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public int getType() {
        return 8;
    }
}

