/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;

public class ValueUtil {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    public static float correctFloat(float given, float min, float max) {
        if (given < min) {
            return min;
        }
        if (given > max) {
            return max;
        }
        return given;
    }

    public static int CorrectInt(int given, int min, int max) {
        if (given < min) {
            return min;
        }
        if (given > max) {
            return max;
        }
        return given;
    }

    public static String nbtToJson(CompoundNBT nbt) {
        return new Gson().toJson(ValueUtil.getJsonValue((INBT)nbt));
    }

    private static JsonElement getJsonValue(INBT value) {
        if (value.func_225647_b_() == CompoundNBT.field_229675_a_) {
            CompoundNBT nbt = (CompoundNBT)value;
            JsonObject root = new JsonObject();
            for (String key : nbt.func_150296_c()) {
                INBT n = nbt.func_74781_a(key);
                JsonElement ele = ValueUtil.getJsonValue(n);
                if (ele == null) continue;
                JsonObject ob = new JsonObject();
                ob.addProperty("type", n.func_225647_b_().func_225648_a_());
                ob.addProperty("type_id", (Number)n.func_74732_a());
                ob.addProperty("pretty_type", n.func_225647_b_().func_225650_b_());
                ob.add("value", ele);
                root.add(key, (JsonElement)ob);
            }
            return root;
        }
        if (value == StringNBT.field_229703_a_) {
            return new JsonPrimitive(value.func_150285_a_());
        }
        if (value instanceof NumberNBT) {
            return new JsonPrimitive(((NumberNBT)value).func_209908_j());
        }
        if (value instanceof CollectionNBT) {
            JsonArray jsonValue = new JsonArray();
            for (INBT n : (CollectionNBT)value) {
                jsonValue.add(ValueUtil.getJsonValue(n));
            }
            return jsonValue;
        }
        return null;
    }

    public static CompoundNBT jsonToNbt(String json) {
        JsonObject ob = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        return ValueUtil.toNbt(ob);
    }

    private static CompoundNBT toNbt(JsonObject json) {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry entry : json.entrySet()) {
            JsonArray array;
            String key = (String)entry.getKey();
            JsonObject ele = (JsonObject)entry.getValue();
            INBTType<? extends INBT> type = ValueUtil.stringToType(ele.get("type").getAsString());
            if (type == StringNBT.field_229703_a_) {
                nbt.func_74778_a(key, ele.get("value").getAsString());
            }
            if (type == IntNBT.field_229691_a_) {
                nbt.func_74768_a(key, ele.get("value").getAsInt());
            }
            if (type == ByteNBT.field_229668_a_) {
                nbt.func_74774_a(key, ele.get("value").getAsByte());
            }
            if (type == LongNBT.field_229697_a_) {
                nbt.func_74772_a(key, ele.get("value").getAsLong());
            }
            if (type == FloatNBT.field_229688_b_) {
                nbt.func_74776_a(key, ele.get("value").getAsFloat());
            }
            if (type == DoubleNBT.field_229683_b_) {
                nbt.func_74780_a(key, ele.get("value").getAsDouble());
            }
            if (type == ShortNBT.field_229700_a_) {
                nbt.func_74777_a(key, ele.get("value").getAsShort());
            }
            if (type == CompoundNBT.field_229675_a_) {
                nbt.func_218657_a(key, (INBT)ValueUtil.toNbt((JsonObject)ele.get("value")));
            }
            if (type == IntArrayNBT.field_229690_a_) {
                array = (JsonArray)ele.get("value");
                nbt.func_218657_a(key, (INBT)new IntArrayNBT(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsInt).collect(Collectors.toList())));
            }
            if (type == ByteArrayNBT.field_229667_a_) {
                array = (JsonArray)ele.get("value");
                nbt.func_218657_a(key, (INBT)new ByteArrayNBT(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsByte).collect(Collectors.toList())));
            }
            if (type != LongArrayNBT.field_229696_a_) continue;
            array = (JsonArray)ele.get("value");
            nbt.func_218657_a(key, (INBT)new LongArrayNBT(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsLong).collect(Collectors.toList())));
        }
        return nbt;
    }

    private static INBTType<? extends INBT> stringToType(String type) {
        if (type.equals(IntNBT.field_229691_a_.func_225648_a_())) {
            return IntNBT.field_229691_a_;
        }
        if (type.equals(ByteNBT.field_229668_a_.func_225648_a_())) {
            return ByteNBT.field_229668_a_;
        }
        if (type.equals(FloatNBT.field_229688_b_.func_225648_a_())) {
            return FloatNBT.field_229688_b_;
        }
        if (type.equals(LongNBT.field_229697_a_.func_225648_a_())) {
            return LongNBT.field_229697_a_;
        }
        if (type.equals(DoubleNBT.field_229683_b_.func_225648_a_())) {
            return DoubleNBT.field_229683_b_;
        }
        if (type.equals(ShortNBT.field_229700_a_.func_225648_a_())) {
            return ShortNBT.field_229700_a_;
        }
        if (type.equals(CompoundNBT.field_229675_a_.func_225648_a_())) {
            return CompoundNBT.field_229675_a_;
        }
        if (type.equals(IntArrayNBT.field_229690_a_.func_225648_a_())) {
            return IntArrayNBT.field_229690_a_;
        }
        if (type.equals(ByteArrayNBT.field_229667_a_.func_225648_a_())) {
            return ByteArrayNBT.field_229667_a_;
        }
        if (type.equals(LongArrayNBT.field_229696_a_.func_225648_a_())) {
            return LongArrayNBT.field_229696_a_;
        }
        return StringNBT.field_229703_a_;
    }

    public static boolean isValidPath(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (ResourceLocation.func_240909_b_((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

