/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.MoneyValueConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.CustomItemScaleSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.DoubleListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.FloatListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.IntListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.ItemListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.LongListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.MoneyValueListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.ResourceListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.StringListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.WildcardSelectorListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.trade_mod.ConfiguredTradeModConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.trade_mod.VillagerTradeModConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.options.ConfigFileOption;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.WidgetBuilder;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.ScreenPositionOptionInput;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.SimpleButtonOption;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.SimpleEditBoxOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.DoubleListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.DoubleOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.EnumOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.FloatListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.FloatOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.IntListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.IntOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.LongListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.LongOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ItemListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ItemOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.MoneyValueListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.MoneyValueOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ResourceListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ResourceOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ScreenPositionOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.WildcardSelectorListOption;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.config.CustomItemScaleConfigOption;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.DoubleParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.FloatParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.LongParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.config.VillagerTradeModsOption;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.configured.ConfiguredTradeModOption;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConfigWidgetHelper {
    private static final List<WidgetBuilder> builders = new ArrayList<WidgetBuilder>();

    public static void registerWidgetBuilder(WidgetBuilder builder) {
        builders.add(builder);
    }

    public static AbstractWidget buildWidgetForOption(Screen screen, ConfigFileOption file, ConfigOption<?> option, Consumer<Object> changeValueConsumer, Supplier<Boolean> canEdit) {
        for (WidgetBuilder builder : builders) {
            AbstractWidget result = builder.createWidgetForOption(screen, file, option, changeValueConsumer, canEdit);
            if (result == null) continue;
            return result;
        }
        return SimpleButtonOption.createUndefined(option);
    }

    static {
        ConfigWidgetHelper.registerWidgetBuilder(new DefaultWidgetBuilder());
    }

    private static class DefaultWidgetBuilder
    implements WidgetBuilder {
        private DefaultWidgetBuilder() {
        }

        @Override
        @Nullable
        public AbstractWidget createWidgetForOption(Screen screen, ConfigFileOption file, ConfigOption<?> o, Consumer<Object> changeValueConsumer, Supplier<Boolean> canEdit) {
            if (o instanceof BooleanOption) {
                BooleanOption option = (BooleanOption)o;
                return SimpleButtonOption.builder(option, changeValueConsumer, canEdit).buttonText(() -> LCText.GUI_SETTINGS_VALUE_TRUE_FALSE.get((Boolean)option.get()).get(new Object[0])).clickHandler2(handler -> handler.accept((Boolean)option.get() == false)).build();
            }
            if (o instanceof DoubleOption) {
                DoubleOption option = (DoubleOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.doubleBuilder().apply(DoubleParser.builder().min(option.lowerLimit).max(option.upperLimit).consumer()).startingValue((Double)option.get()).handler(handler::accept)).optionChangeHandler(text -> {
                    double newVal = (Double)option.get();
                    if (newVal == 0.0 && text.getValue().isEmpty()) {
                        return;
                    }
                    if (newVal == 0.0) {
                        text.setValue("0");
                    } else {
                        text.setValue(String.valueOf(option.get()));
                    }
                }).build();
            }
            if (o instanceof EnumOption) {
                EnumOption option = (EnumOption)o;
                return SimpleButtonOption.builder(option, changeValueConsumer, canEdit).buttonText(() -> EasyText.literal(((Enum)option.get()).name())).clickHandler((left, handler) -> {
                    Enum current = (Enum)option.get();
                    int nextOrdinal = current.ordinal() + (left != false ? 1 : -1);
                    Enum[] all = (Enum[])option.clazz.getEnumConstants();
                    Enum wrapDefault = left != false ? all[0] : all[all.length - 1];
                    handler.accept(EnumUtil.enumFromOrdinal((int)nextOrdinal, (Enum[])all, (Enum)wrapDefault));
                }).build();
            }
            if (o instanceof FloatOption) {
                FloatOption option = (FloatOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.floatBuilder().apply(FloatParser.builder().min(option.lowerLimit).max(option.upperLimit).consumer()).startingValue((Float)option.get()).handler(handler::accept)).optionChangeHandler(text -> {
                    float newVal = ((Float)option.get()).floatValue();
                    if ((double)newVal == 0.0 && text.getValue().isEmpty()) {
                        return;
                    }
                    if ((double)newVal == 0.0) {
                        text.setValue("0");
                    } else {
                        text.setValue(String.valueOf(option.get()));
                    }
                }).build();
            }
            if (o instanceof IntOption) {
                IntOption option = (IntOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.intBuilder().apply(IntParser.builder().min(option.lowerLimit).max(option.upperLimit).consumer()).startingValue((Integer)option.get()).handler(handler::accept)).optionChangeHandler(text -> {
                    int newVal = (Integer)option.get();
                    if ((double)newVal == 0.0 && text.getValue().isEmpty()) {
                        return;
                    }
                    text.setValue(String.valueOf(option.get()));
                }).build();
            }
            if (o instanceof LongOption) {
                LongOption option = (LongOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.longBuilder().apply(LongParser.builder().min(option.lowerLimit).max(option.upperLimit).consumer()).startingValue((Long)option.get()).handler(handler::accept)).optionChangeHandler(text -> {
                    long newVal = (Long)option.get();
                    if ((double)newVal == 0.0 && text.getValue().isEmpty()) {
                        return;
                    }
                    text.setValue(String.valueOf(option.get()));
                }).build();
            }
            if (o instanceof StringOption) {
                StringOption option = (StringOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.stringBuilder().startingValue((String)option.get()).handler(handler::accept)).optionChangeHandler(text -> text.setValue((String)option.get())).build();
            }
            if (o instanceof ItemOption) {
                ItemOption option = (ItemOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.stringBuilder().startingValue(BuiltInRegistries.ITEM.getKey((Object)((Item)option.get())).toString()).handler(string -> {
                    if (string.isEmpty() && option.allowedValue(Items.AIR)) {
                        handler.accept(Items.AIR);
                    }
                    try {
                        Item item;
                        ResourceLocation id = VersionUtil.parseResource(string);
                        if (BuiltInRegistries.ITEM.containsKey(id) && option.allowedValue(item = (Item)BuiltInRegistries.ITEM.get(id))) {
                            handler.accept(item);
                        }
                    }
                    catch (ResourceLocationException resourceLocationException) {
                        // empty catch block
                    }
                })).optionChangeHandler(text -> text.setValue(BuiltInRegistries.ITEM.getKey((Object)((Item)option.get())).toString())).build();
            }
            if (o instanceof MoneyValueOption) {
                MoneyValueOption option = (MoneyValueOption)o;
                return SimpleButtonOption.builder(option, changeValueConsumer, canEdit).buttonText(() -> ((MoneyValue)option.get()).getText(LCText.GUI_MONEY_STORAGE_EMPTY.get(new Object[0]))).openScreen(handler -> new MoneyValueConfigScreen(screen, file, option, (Consumer<Object>)handler)).build();
            }
            if (o instanceof ResourceOption) {
                ResourceOption option = (ResourceOption)o;
                return SimpleEditBoxOption.builder(option, changeValueConsumer, canEdit).inputBoxSetup(handler -> TextInputUtil.stringBuilder().startingValue(((ResourceLocation)option.get()).toString()).handler(string -> {
                    try {
                        handler.accept(VersionUtil.parseResource(string));
                    }
                    catch (ResourceLocationException resourceLocationException) {
                        // empty catch block
                    }
                })).optionChangeHandler(text -> text.setValue(((ResourceLocation)option.get()).toString())).build();
            }
            if (o instanceof ScreenPositionOption) {
                ScreenPositionOption option = (ScreenPositionOption)o;
                return ScreenPositionOptionInput.create(option, changeValueConsumer, canEdit);
            }
            if (o instanceof DoubleListOption) {
                DoubleListOption option = (DoubleListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new DoubleListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof FloatListOption) {
                FloatListOption option = (FloatListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new FloatListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof IntListOption) {
                IntListOption option = (IntListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new IntListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof LongListOption) {
                LongListOption option = (LongListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new LongListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof StringListOption) {
                StringListOption option = (StringListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new StringListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof ItemListOption) {
                ItemListOption option = (ItemListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new ItemListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof MoneyValueListOption) {
                MoneyValueListOption option = (MoneyValueListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new MoneyValueListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof ResourceListOption) {
                ResourceListOption option = (ResourceListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new ResourceListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof WildcardSelectorListOption) {
                WildcardSelectorListOption option = (WildcardSelectorListOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new WildcardSelectorListSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof CustomItemScaleConfigOption) {
                CustomItemScaleConfigOption option = (CustomItemScaleConfigOption)o;
                return SimpleButtonOption.createForList(option, changeValueConsumer, screen, file, handler -> new CustomItemScaleSettings(option, (Consumer<Object>)handler));
            }
            if (o instanceof ConfiguredTradeModOption) {
                ConfiguredTradeModOption option = (ConfiguredTradeModOption)o;
                return SimpleButtonOption.builder(option, changeValueConsumer, canEdit).buttonText(LCText.CONFIG_OPTION_EDIT).openScreen(handler -> new ConfiguredTradeModConfigScreen(screen, file, option, changeValueConsumer)).build();
            }
            if (o instanceof VillagerTradeModsOption) {
                VillagerTradeModsOption option = (VillagerTradeModsOption)o;
                return SimpleButtonOption.builder(option, changeValueConsumer, canEdit).buttonText(LCText.CONFIG_OPTION_EDIT).openScreen(handler -> new VillagerTradeModConfigScreen(screen, file, option, changeValueConsumer)).build();
            }
            return null;
        }
    }
}

