/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloatOption
extends ConfigOption<Float> {
    public final float lowerLimit;
    public final float upperLimit;
    private final ConfigParser<Float> parser;

    public static ConfigParser<Float> makeParser(float lowerLimit, float upperLimit) {
        return new Parser(lowerLimit, upperLimit);
    }

    protected FloatOption(Supplier<Float> defaultValue, float lowerLimit, float upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = FloatOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    public boolean allowedValue(Float newValue) {
        return newValue.floatValue() >= this.lowerLimit && newValue.floatValue() <= this.upperLimit;
    }

    @Override
    protected ConfigParser<Float> getParser() {
        return this.parser;
    }

    @Override
    protected List<String> bonusComments() {
        return Lists.newArrayList((Object[])new String[]{"Range: " + this.lowerLimit + " -> " + this.upperLimit, "Default: " + String.valueOf(this.getDefaultValue())});
    }

    @Override
    protected List<Component> bonusCommentTooltips() {
        return Lists.newArrayList((Object[])new Component[]{LCText.CONFIG_OPTION_RANGE.get(Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit)), LCText.CONFIG_OPTION_DEFAULT.get(this.getDefaultValue())});
    }

    public static FloatOption create(float defaultValue) {
        return new FloatOption(() -> Float.valueOf(defaultValue), -3.4028235E38f, Float.MAX_VALUE);
    }

    public static FloatOption create(float defaultValue, float lowerLimit) {
        return new FloatOption(() -> Float.valueOf(defaultValue), lowerLimit, Float.MAX_VALUE);
    }

    public static FloatOption create(float defaultValue, float lowerLimit, float upperLimit) {
        return new FloatOption(() -> Float.valueOf(defaultValue), lowerLimit, upperLimit);
    }

    public static FloatOption create(Supplier<Float> defaultValue) {
        return new FloatOption(defaultValue, -3.4028235E38f, Float.MAX_VALUE);
    }

    public static FloatOption create(Supplier<Float> defaultValue, float lowerLimit) {
        return new FloatOption(defaultValue, lowerLimit, Float.MAX_VALUE);
    }

    public static FloatOption create(Supplier<Float> defaultValue, float lowerLimit, float upperLimit) {
        return new FloatOption(defaultValue, lowerLimit, upperLimit);
    }

    private static class Parser
    implements ConfigParser<Float> {
        private final float lowerLimit;
        private final float upperLimit;

        private Parser(float lowerLimit, float upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        public Float tryParse(String cleanLine) throws ConfigParsingException {
            try {
                return Float.valueOf(MathUtil.clamp(Float.parseFloat(cleanLine), this.lowerLimit, this.upperLimit));
            }
            catch (NumberFormatException e) {
                throw new ConfigParsingException("Error parsing float!", e);
            }
        }

        @Override
        public String write(Float value) {
            return value.toString();
        }
    }
}

