/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.filter;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IItemTradeFilter {
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack var1);

    @Nullable
    public List<Component> getCustomTooltip(ItemStack var1);

    default public List<ItemStack> getDisplayableItems(ItemStack stack, @Nullable IItemHandler availableItems) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        Predicate<ItemStack> filter = this.getFilter(stack);
        if (filter == null) {
            return results;
        }
        if (availableItems != null) {
            for (int i = 0; i < availableItems.getSlots(); ++i) {
                ItemStack item = availableItems.getStackInSlot(i);
                if (item.isEmpty() || !filter.test(item) || IItemTradeFilter.isInList(results, item)) continue;
                results.add(item.copyWithCount(stack.getCount()));
            }
        } else {
            try {
                boolean hasPermissions = LightmansCurrency.getProxy().getHasPermissionsSetting();
                Level level = LightmansCurrency.getProxy().safeGetDummyLevel();
                if (level != null) {
                    CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)level.enabledFeatures(), (boolean)hasPermissions, (HolderLookup.Provider)level.registryAccess());
                }
            }
            catch (Exception e) {
                LightmansCurrency.LogWarning("Failed to rebuild creative tabs, display items may be inaccurate.", e);
            }
            for (CreativeModeTab tab : CreativeModeTabs.allTabs()) {
                if (tab.getType() != CreativeModeTab.Type.CATEGORY) continue;
                for (ItemStack item : tab.getDisplayItems()) {
                    if (!filter.test(item) || IItemTradeFilter.isInList(results, item)) continue;
                    results.add(item.copyWithCount(stack.getCount()));
                }
            }
        }
        return results;
    }

    public static boolean isInList(List<ItemStack> list, ItemStack item) {
        for (ItemStack i : list) {
            if (!InventoryUtil.ItemMatches(i, item)) continue;
            return true;
        }
        return false;
    }
}

