/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ImageIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("texture"), ImageIcon::loadImage, ImageIcon::parseImage);
    private final NormalSprite sprite;

    private ImageIcon(NormalSprite sprite) {
        super(TYPE);
        this.sprite = sprite;
    }

    public static IconData ofImage(ResourceLocation image, int u, int v) {
        return ImageIcon.ofImage(new SpriteSource(image, u, v, 16, 16));
    }

    public static IconData ofImage(SpriteSource sprite) {
        return new ImageIcon(new NormalSprite(sprite));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        this.sprite.render(gui, x, y);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.putString("Image", this.sprite.image.texture().toString());
        tag.putInt("u", this.sprite.image.u());
        tag.putInt("v", this.sprite.image.v());
        tag.putInt("w", this.sprite.image.width());
        tag.putInt("h", this.sprite.image.height());
        tag.putInt("tw", this.sprite.image.textureWidth());
        tag.putInt("th", this.sprite.image.textureHeight());
    }

    @Override
    protected void writeAdditional(JsonObject json, HolderLookup.Provider lookup) {
        json.addProperty("Image", this.sprite.image.texture().toString());
        json.addProperty("u", (Number)this.sprite.image.u());
        json.addProperty("v", (Number)this.sprite.image.v());
        json.addProperty("w", (Number)this.sprite.image.width());
        json.addProperty("h", (Number)this.sprite.image.height());
        json.addProperty("tw", (Number)this.sprite.image.textureWidth());
        json.addProperty("th", (Number)this.sprite.image.textureHeight());
    }

    private static IconData loadImage(CompoundTag tag) {
        ResourceLocation image = VersionUtil.parseResource(tag.getString("Image"));
        int u = tag.getInt("u");
        int v = tag.getInt("v");
        int w = tag.getInt("w");
        int h = tag.getInt("h");
        int tw = tag.getInt("tw");
        int th = tag.getInt("th");
        return ImageIcon.ofImage(new SpriteSource(image, u, v, w, h, tw, th));
    }

    private static IconData parseImage(JsonObject json) {
        ResourceLocation image = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Image"));
        int u = GsonHelper.getAsInt((JsonObject)json, (String)"u");
        int v = GsonHelper.getAsInt((JsonObject)json, (String)"v");
        int w = GsonHelper.getAsInt((JsonObject)json, (String)"w");
        int h = GsonHelper.getAsInt((JsonObject)json, (String)"h");
        int tw = GsonHelper.getAsInt((JsonObject)json, (String)"tw");
        int th = GsonHelper.getAsInt((JsonObject)json, (String)"th");
        return ImageIcon.ofImage(new SpriteSource(image, u, v, w, h, tw, th));
    }
}

