/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.settings.directional;

import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsHolder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IDirectionalSettingsObject
extends IDirectionalSettingsHolder {
    @Nullable
    public Block getDisplayBlock();

    public DirectionalSettingsState getSidedState(Direction var1);

    @Nullable
    default public ResourceLocation getVariant() {
        return null;
    }

    default public boolean allowInputSide(Direction side) {
        return this.getSidedState(side).allowsInputs();
    }

    default public boolean hasInputSide() {
        for (Direction side : Direction.values()) {
            if (!this.allowInputSide(side)) continue;
            return true;
        }
        return false;
    }

    default public boolean allowOutputSide(Direction side) {
        return this.getSidedState(side).allowsOutputs();
    }

    default public boolean hasOutputSide() {
        for (Direction side : Direction.values()) {
            if (!this.allowOutputSide(side)) continue;
            return true;
        }
        return false;
    }
}

