/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class EasyScreenHelper {
    @Nullable
    @Deprecated
    public static IEasyTickable getWidgetTicker(@Nullable Object widget) {
        if (widget instanceof IEasyTickable) {
            IEasyTickable t = (IEasyTickable)widget;
            return t;
        }
        return null;
    }

    public static void RenderTooltips(@Nonnull EasyGuiGraphics gui, @Nonnull List<ITooltipSource> tooltipSources) {
        for (ITooltipSource tooltipSource : tooltipSources) {
            if (!tooltipSource.renderTooltip(gui)) continue;
            return;
        }
    }

    public static List<Component> getTooltipFromItem(ItemStack item) {
        return item.isEmpty() ? new ArrayList() : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)item);
    }

    public static void RenderItemTooltip(@Nonnull EasyGuiGraphics gui, @Nonnull ItemStack item) {
        EasyScreenHelper.RenderItemTooltip(gui, item, EasyScreenHelper.getTooltipFromItem(item));
    }

    public static void RenderItemTooltipWithModifiers(@Nonnull EasyGuiGraphics gui, @Nonnull ItemStack item, @Nonnull Consumer<List<Component>> tooltipEditor) {
        List<Component> text = EasyScreenHelper.getTooltipFromItem(item);
        tooltipEditor.accept(text);
        EasyScreenHelper.RenderItemTooltip(gui, item, text);
    }

    public static void RenderItemTooltipWithCount(@Nonnull EasyGuiGraphics gui, @Nonnull ItemStack item, int maxCount, ChatFormatting ... formatting) {
        List<Component> text = EasyScreenHelper.getTooltipFromItem(item);
        text.add(EasyScreenHelper.formatItemCount(item.getCount(), maxCount, formatting));
        EasyScreenHelper.RenderItemTooltip(gui, item, text);
    }

    public static void RenderItemTooltip(@Nonnull EasyGuiGraphics gui, @Nonnull ItemStack item, @Nonnull List<Component> text) {
        gui.getGui().renderTooltip(gui.font, text, item.getTooltipImage(), item, gui.mousePos.x, gui.mousePos.y);
    }

    public static Component formatItemCount(int count, int maxCount, ChatFormatting ... formatting) {
        DecimalFormat f = new DecimalFormat();
        MutableComponent c = EasyText.literal(f.format(count));
        if (count == maxCount) {
            c.withStyle(ChatFormatting.GOLD);
        } else if (count > maxCount) {
            c.withStyle(ChatFormatting.DARK_RED);
        }
        return LCText.TOOLTIP_ITEM_COUNT.get(c, f.format(maxCount)).withStyle(formatting);
    }
}

