/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.rotation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandlerType;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class FacingRotation
extends RotationHandler {
    public static final RotationHandlerType TYPE = json -> FacingRotation.getInstance();
    private static final FacingRotation INSTANCE = new FacingRotation();

    public static FacingRotation getInstance() {
        return INSTANCE;
    }

    private FacingRotation() {
        super(TYPE);
    }

    @Override
    protected List<Quaternionf> rotate(BlockState state, float partialTicks) {
        Block block = state.getBlock();
        if (block instanceof IRotatableBlock) {
            IRotatableBlock rb = (IRotatableBlock)block;
            int facing = rb.getFacing(state).get2DDataValue();
            return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f));
        }
        return ImmutableList.of();
    }

    @Override
    protected void writeAdditional(JsonObject json) {
    }
}

