/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IClientTicker;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlockEntity;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.menus.containers.CoinContainer;
import io.github.lightman314.lightmanscurrency.common.menus.containers.UpgradeContainer;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CoinChestBlockEntity
extends EasyBlockEntity
implements IUpgradeable,
IClientTicker,
IServerTicker,
LidBlockEntity,
IUpgradeableBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, @Nonnull BlockState state) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(Level level, BlockPos pos, @Nonnull BlockState state) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int oldCount, int newCount) {
            level.blockEvent(CoinChestBlockEntity.this.worldPosition, ModBlocks.COIN_CHEST.get(), 1, newCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof CoinChestMenu)) return false;
            CoinChestMenu ccm = (CoinChestMenu)abstractContainerMenu;
            if (ccm.be != CoinChestBlockEntity.this) return false;
            return true;
        }
    };
    public static final int STORAGE_ROWS = 3;
    public static final int STORAGE_SIZE = 27;
    public static final int UPGRADE_SIZE = 3;
    private final ItemHandler handler = new ItemHandler(this);
    private Component customName = null;
    private CoinContainer storage;
    private final UpgradeContainer upgrades;
    private List<CoinChestUpgradeData> unfilteredUpgradeDataCache = new ArrayList<CoinChestUpgradeData>();
    private List<CoinChestUpgradeData> upgradeDataCache = new ArrayList<CoinChestUpgradeData>();
    private boolean allowEvents = true;
    private final List<Player> relevantPlayers = new ArrayList<Player>();

    public int getOpenerCount() {
        return this.openersCounter.getOpenerCount();
    }

    public IItemHandler getItemHandler() {
        return this.handler;
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.markCustomNameDirty();
    }

    public Component getDisplayName() {
        return this.customName != null ? this.customName : LCText.BLOCK_MONEY_CHEST.get(new Object[0]);
    }

    public final CoinContainer getStorage() {
        return this.storage;
    }

    @Nonnull
    public final UpgradeContainer getUpgrades() {
        return this.upgrades;
    }

    public final ImmutableList<CoinChestUpgradeData> getChestUpgrades() {
        this.checkUpgradeCache();
        return ImmutableList.copyOf(this.upgradeDataCache);
    }

    public final ImmutableList<CoinChestUpgradeData> getActiveUpgrades() {
        return ImmutableList.copyOf((Collection)this.getChestUpgrades().stream().filter(CoinChestUpgradeData::isActive).collect(Collectors.toList()));
    }

    private void checkUpgradeCache() {
        if (this.unfilteredUpgradeDataCache.size() != 3) {
            this.refreshUpgradeCache();
        }
    }

    private void refreshUpgradeCache() {
        List<CoinChestUpgradeData> oldList = this.unfilteredUpgradeDataCache;
        this.unfilteredUpgradeDataCache = new ArrayList<CoinChestUpgradeData>();
        for (int i = 0; i < 3; ++i) {
            this.unfilteredUpgradeDataCache.add(CoinChestUpgradeData.forItem(this.upgrades.getItem(i), i, this::markUpgradesChanged));
            if (i >= oldList.size()) continue;
            this.unfilteredUpgradeDataCache.get(i).copyRelevantData(oldList.get(i));
        }
        this.upgradeDataCache = this.unfilteredUpgradeDataCache.stream().filter(CoinChestUpgradeData::notNull).toList();
    }

    @Nonnull
    public final CoinChestUpgradeData getChestUpgradeForSlot(int slot) {
        this.checkUpgradeCache();
        List<CoinChestUpgradeData> list = this.unfilteredUpgradeDataCache;
        if (slot >= 0 && slot < list.size()) {
            return list.get(slot);
        }
        return CoinChestUpgradeData.NULL;
    }

    @Nullable
    public final CoinChestUpgradeData getChestUpgradeOfType(CoinChestUpgrade type) {
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            if (data.upgrade != type) continue;
            return data;
        }
        return null;
    }

    public CoinChestBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COIN_CHEST.get(), pos, state);
        this.storage = new CoinContainer(27);
        this.storage.addListener(i -> this.markStorageDirty());
        this.upgrades = new UpgradeContainer(3, this);
        this.upgrades.addListener(i -> this.markUpgradesDirty());
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("Name")) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("Name"), (HolderLookup.Provider)lookup);
        }
        if (compound.contains("Storage")) {
            this.storage = new CoinContainer((Container)InventoryUtil.loadAllItems("Storage", compound, 27, lookup));
            this.storage.addListener(i -> this.markStorageDirty());
        }
        if (compound.contains("Upgrades")) {
            this.upgrades.load("Upgrades", compound, lookup);
            this.refreshUpgradeCache();
        }
    }

    public static MenuProvider getMenuProvider(CoinChestBlockEntity be) {
        return new CoinChestMenuProvider(be);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveCustomName(compound, lookup);
        this.saveStorage(compound, lookup);
        this.saveUpgrades(compound, lookup);
    }

    protected CompoundTag saveCustomName(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (this.customName != null) {
            compound.putString("Name", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)lookup));
        }
        return compound;
    }

    protected CompoundTag saveStorage(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        InventoryUtil.saveAllItems("Storage", compound, (Container)this.storage, lookup);
        return compound;
    }

    protected CompoundTag saveUpgrades(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.upgrades.save("Upgrades", compound, lookup);
        return compound;
    }

    public final void markCustomNameDirty() {
        this.setChanged();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveCustomName(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
        }
    }

    public final void markStorageDirty() {
        this.setChanged();
        if (this.isServer() && this.allowEvents) {
            this.allowEvents = false;
            for (CoinChestUpgradeData data : this.getActiveUpgrades()) {
                try {
                    data.upgrade.OnStorageChanged(this, data);
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error on CoinChestUpgrade Storage Change listener!", t);
                }
            }
            this.allowEvents = true;
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveStorage(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
        }
    }

    public final void markUpgradesDirty() {
        this.refreshUpgradeCache();
        this.markUpgradesChanged();
    }

    private void markUpgradesChanged() {
        this.setChanged();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveUpgrades(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
        }
    }

    public final void checkUpgradeEquipped(int slot) {
        if (this.isClient()) {
            return;
        }
        CoinChestUpgradeData data = this.getChestUpgradeForSlot(slot);
        if (data != null) {
            try {
                data.upgrade.OnEquip(this, data);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error during CoinChestUpgrade's Equip listener!", t);
            }
        }
        for (int i = 0; i < this.relevantPlayers.size(); ++i) {
            Player player = this.relevantPlayers.get(i);
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof CoinChestMenu) {
                CoinChestMenu menu = (CoinChestMenu)abstractContainerMenu;
                if (menu.be == this) {
                    menu.SendMessageToClient(menu.builder().setBoolean("RefreshTabs", true));
                    continue;
                }
            }
            this.relevantPlayers.remove(i);
            --i;
        }
    }

    @Override
    public void clientTick() {
        this.chestLidController.tickLid();
    }

    @Override
    public void serverTick() {
        for (CoinChestUpgradeData data : this.getActiveUpgrades()) {
            data.tick(this);
        }
    }

    @Override
    public boolean allowUpgrade(@Nonnull UpgradeType type) {
        boolean bl;
        if (type instanceof CoinChestUpgrade) {
            CoinChestUpgrade upgrade = (CoinChestUpgrade)type;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean allowAccess(@Nullable Player player) {
        if (LCAdminMode.isAdminPlayer(player)) {
            return true;
        }
        for (CoinChestUpgradeData data : this.getActiveUpgrades()) {
            if (!data.upgrade.BlockAccess(this, data, player)) continue;
            return false;
        }
        return true;
    }

    public void onValidBlockRemoval() {
        for (CoinChestUpgradeData data : this.getActiveUpgrades()) {
            data.upgrade.OnValidBlockRemoval(this, data);
        }
    }

    public void onBlockRemoval() {
        for (CoinChestUpgradeData data : this.getActiveUpgrades()) {
            data.upgrade.OnBlockRemoval(this, data);
        }
    }

    public float getOpenNess(float partial) {
        return this.chestLidController.getOpenness(partial);
    }

    public boolean triggerEvent(int event, int value) {
        if (event == 1) {
            this.chestLidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(event, value);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
        if (!this.relevantPlayers.contains(player)) {
            this.relevantPlayers.add(player);
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
        this.relevantPlayers.remove(player);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    private static class ItemHandler
    extends InvWrapper {
        private final CoinChestBlockEntity blockEntity;

        public ItemHandler(CoinChestBlockEntity blockEntity) {
            super((Container)blockEntity.storage);
            this.blockEntity = blockEntity;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return CoinAPI.getApi().IsCoin(stack, false);
        }

        @Nonnull
        public Container getInv() {
            return this.blockEntity.storage;
        }
    }

    private record CoinChestMenuProvider(CoinChestBlockEntity be) implements MenuProvider
    {
        @Nonnull
        public Component getDisplayName() {
            return this.be.getDisplayName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new CoinChestMenu(id, inventory, this.be);
        }
    }
}

