/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.variant;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.VariantSelectMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
public interface IVariantBlock {
    public static final BooleanProperty VARIANT = BooleanProperty.create((String)"variant");

    default public int getModelIndex(BlockState state) {
        int index = 0;
        boolean wide = this instanceof IWideBlock;
        boolean tall = this instanceof ITallBlock;
        boolean deep = this instanceof IDeepBlock;
        if (wide && !((Boolean)state.getValue((Property)IWideBlock.ISLEFT)).booleanValue()) {
            ++index;
        }
        if (deep && !((Boolean)state.getValue((Property)IDeepBlock.IS_FRONT)).booleanValue()) {
            index += wide ? 2 : 1;
        }
        if (tall && !((Boolean)state.getValue((Property)ITallBlock.ISBOTTOM)).booleanValue()) {
            index += wide && deep ? 4 : (wide || deep ? 2 : 1);
        }
        return index;
    }

    default public ResourceLocation getBlockID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof Block) {
            Block block = (Block)iVariantBlock;
            return BuiltInRegistries.BLOCK.getKey((Object)block);
        }
        throw new IllegalStateException("IVariantBlock must be applied to a Block class!");
    }

    default public ResourceLocation getItemID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof ItemLike) {
            ItemLike item = (ItemLike)iVariantBlock;
            return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        }
        return this.getBlockID();
    }

    default public List<ResourceLocation> getValidVariants() {
        return ModelVariantDataManager.getPotentialVariants(this.getBlockID());
    }

    default public int requiredModels() {
        return this.modelsRequiringRotation();
    }

    default public int modelsRequiringRotation() {
        int count = 1;
        if (this instanceof IWideBlock) {
            count *= 2;
        }
        if (this instanceof ITallBlock) {
            count *= 2;
        }
        if (this instanceof IDeepBlock) {
            count *= 2;
        }
        return count;
    }

    @Nullable
    default public ResourceLocation getCustomDefaultModel(int index) {
        return null;
    }

    public static boolean tryUseWand(Player player, BlockPos pos) {
        Level level = player.level();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IVariantBlock) {
            IVariantSupportingBlockEntity be;
            IOwnableBlock ownable;
            IVariantBlock variantBlock = (IVariantBlock)block;
            Block block2 = state.getBlock();
            if (block2 instanceof IOwnableBlock && !(ownable = (IOwnableBlock)block2).canBreak(player, (LevelAccessor)level, pos, state)) {
                return false;
            }
            if (level.isClientSide) {
                return true;
            }
            block2 = level.getBlockEntity(pos);
            if (block2 instanceof IVariantSupportingBlockEntity && (be = (IVariantSupportingBlockEntity)block2).isVariantLocked()) {
                player.displayClientMessage((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.RED), true);
                return true;
            }
            player.openMenu(VariantSelectMenu.providerFor(pos), pos);
            return true;
        }
        return false;
    }
}

