/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.MoneyValueOption;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.BonusForEnchantment;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.ItemOverride;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.ValueInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class RepairWithMoneyData {
    public static final Codec<RepairWithMoneyData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ValueInput.CODEC.optionalFieldOf("baseCost", (Object)new ValueInput("")).forGetter(d -> d.baseCost), (App)BonusForEnchantment.CODEC.listOf().fieldOf("enchantmentExtraCost").forGetter(d -> d.enchantmentExtras), (App)ItemOverride.CODEC.listOf().fieldOf("itemOverrides").forGetter(d -> d.itemOverrides)).apply((Applicative)builder, RepairWithMoneyData::new));
    private boolean forceCache = true;
    private boolean updatingCache = false;
    private long lastCacheTime = 0L;
    private final ValueInput baseCost;
    private final List<BonusForEnchantment> enchantmentExtras;
    private final List<ItemOverride> itemOverrides;

    public MoneyValue getBaseCost() {
        this.checkCache();
        return this.baseCost.getCost();
    }

    public MoneyValue getRepairCost(@Nonnull ItemStack item, @Nonnull ItemEnchantments enchantments) {
        this.checkCache();
        MoneyValue base = this.baseCost.getCost();
        for (ItemOverride io : this.itemOverrides) {
            if (!io.matches(item)) continue;
            base = io.getCost();
        }
        MoneyValue total = base;
        for (Holder holder : enchantments.keySet()) {
            for (BonusForEnchantment b : this.enchantmentExtras) {
                if (!holder.is(b.enchantment)) continue;
                int level = Math.min(enchantments.getLevel(holder), Math.max(1, b.maxLevelCalculation <= 0 ? Integer.MAX_VALUE : b.maxLevelCalculation));
                MoneyValue toAdd = b.getCost().percentageOfValue(level * 100);
                MoneyValue newTotal = total.addValue(toAdd);
                if (newTotal == null) continue;
                total = newTotal;
            }
        }
        return total == null ? base : total;
    }

    private RepairWithMoneyData(@Nonnull ValueInput baseCost, @Nonnull List<BonusForEnchantment> enchantmentExtras, @Nonnull List<ItemOverride> itemOverrides) {
        this.baseCost = baseCost;
        this.enchantmentExtras = ImmutableList.copyOf(enchantmentExtras);
        this.enchantmentExtras.forEach(e -> e.init(this));
        this.itemOverrides = ImmutableList.copyOf(itemOverrides);
    }

    private void checkCache() {
        if (this.updatingCache) {
            return;
        }
        if (this.forceCache || System.currentTimeMillis() - this.lastCacheTime >= 120000L) {
            this.updatingCache = true;
            this.forceCache = false;
            this.lastCacheTime = System.currentTimeMillis();
            this.baseCost.updateCache();
            this.itemOverrides.forEach(ValueInput::updateCache);
            this.enchantmentExtras.forEach(ValueInput::updateCache);
            this.updatingCache = false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.baseCost, this.enchantmentExtras, this.itemOverrides);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepairWithMoneyData) {
            RepairWithMoneyData other = (RepairWithMoneyData)obj;
            return this.baseCost.equals(other.baseCost) && this.itemOverrides.equals(other.itemOverrides) && this.enchantmentExtras.equals(other.enchantmentExtras);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ValueInput baseCost = new ValueInput("");
        private final Map<ResourceLocation, BonusForEnchantment> enchantmentExtras = new HashMap<ResourceLocation, BonusForEnchantment>();
        private final List<ItemOverride> itemOverrides = new ArrayList<ItemOverride>();

        public Builder baseCost(String baseCostInput) {
            this.baseCost = new ValueInput(baseCostInput);
            return this;
        }

        public Builder baseCost(MoneyValueOption configOption) {
            return this.baseCost(ValueInput.writeConfig(configOption));
        }

        public Builder bonusForEnchantment(ResourceKey<Enchantment> enchantment, MoneyValueOption bonusCost, int maxLevelCalculation) {
            return this.bonusForEnchantment(enchantment.location(), bonusCost, maxLevelCalculation);
        }

        public Builder bonusForEnchantment(ResourceKey<Enchantment> enchantment, String bonusCost, int maxLevelCalculation) {
            return this.bonusForEnchantment(enchantment.location(), bonusCost, maxLevelCalculation);
        }

        public Builder bonusForEnchantment(ResourceLocation enchantmentID, MoneyValueOption bonusCost, int maxLevelCalculation) {
            return this.bonusForEnchantment(enchantmentID, ValueInput.writeConfig(bonusCost), maxLevelCalculation);
        }

        public Builder bonusForEnchantment(ResourceLocation enchantmentID, String bonusCost, int maxLevelCalculation) {
            this.enchantmentExtras.put(enchantmentID, new BonusForEnchantment(bonusCost, enchantmentID, maxLevelCalculation));
            return this;
        }

        public Builder itemOverride(ItemOverride override) {
            this.itemOverrides.add(override);
            return this;
        }

        public ItemOverride.Builder itemOverride(String baseCost) {
            return ItemOverride.builder(baseCost, this);
        }

        public RepairWithMoneyData build() {
            return new RepairWithMoneyData(this.baseCost, this.enchantmentExtras.values().stream().toList(), this.itemOverrides);
        }
    }
}

