/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.blockentity.MoneyBagBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.data.types.LootTableEntry;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.data.MoneyBagData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagItem
extends BlockItem {
    public static final ResourceLocation PROPERTY = VersionUtil.lcResource("money_bag_size");

    public MoneyBagItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_MONEY_BAG);
        List<ItemStack> contents = MoneyBagItem.getContents(stack);
        if (!contents.isEmpty()) {
            if (flag.hasControlDown()) {
                for (ItemStack coin : contents) {
                    if (coin.getCount() > 1) {
                        tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_MULTIPLE.get(coin.getCount(), coin.getHoverName()));
                        continue;
                    }
                    tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_SINGLE.get(coin.getHoverName()));
                }
            } else {
                tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_HOLD_CTRL.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
            }
        }
        if (flag.isAdvanced()) {
            tooltip.add((Component)LCText.TOOLTIP_MONEY_BAG_SIZE.get(MoneyBagItem.getSize(stack)).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (stack.has(ModDataComponents.LOOT_TABLE_ENTRY)) {
            LootTableEntry entry = (LootTableEntry)stack.get(ModDataComponents.LOOT_TABLE_ENTRY);
            tooltip.add((Component)LCText.TOOLTIP_CONTAINER_ITEM_LOOT_TABLE.get(entry.lootTable().location()).withStyle(ChatFormatting.DARK_GRAY));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<ItemStack> contents;
        ItemStack droppedCoin;
        int size = MoneyBagItem.getSize(stack);
        attacker.playSound(ModSounds.COINS_CLINKING.get(), 0.25f + 0.2f * (float)size, 1.0f);
        double dropChance = (Double)LCConfig.SERVER.moneyBagCoinLossChance.get();
        RandomSource random = attacker.getRandom();
        if (dropChance > 0.0 && random.nextDouble() < dropChance && !(droppedCoin = MoneyBagBlockEntity.removeRandomItem(contents = MoneyBagItem.getContents(stack), random)).isEmpty()) {
            MoneyBagItem.setContents(stack, contents);
            Level level = attacker.level();
            Vec3 position = attacker.getEyePosition();
            Vec3 lookdirection = attacker.getLookAngle();
            double averageSpeed = 5.0;
            double maxDelta = 0.25;
            Vec3 itemSpeed = lookdirection.multiply(random.triangle(averageSpeed, maxDelta), random.triangle(averageSpeed, maxDelta), random.triangle(averageSpeed, maxDelta));
            ItemEntity item = new ItemEntity(level, position.x, position.y, position.z, droppedCoin);
            item.setDeltaMovement(itemSpeed);
            item.setThrower((Entity)attacker);
            level.addFreshEntity((Entity)item);
        }
    }

    public static List<ItemStack> getContents(ItemStack moneybag) {
        if (moneybag.getItem() instanceof MoneyBagItem) {
            return InventoryUtil.copyList(((MoneyBagData)moneybag.getOrDefault(ModDataComponents.MONEY_BAG_CONTENTS, (Object)MoneyBagData.EMPTY)).contents());
        }
        return new ArrayList<ItemStack>();
    }

    public static void setContents(ItemStack moneyBag, List<ItemStack> contents) {
        if (moneyBag.getItem() instanceof MoneyBagItem) {
            moneyBag.set(ModDataComponents.MONEY_BAG_CONTENTS, (Object)MoneyBagData.of(contents));
        }
    }

    public static int getSize(ItemStack moneybag) {
        if (moneybag.getItem() instanceof MoneyBagItem) {
            return MathUtil.clamp(((MoneyBagData)moneybag.getOrDefault(ModDataComponents.MONEY_BAG_CONTENTS, (Object)MoneyBagData.EMPTY)).size(), 0, 3);
        }
        return 0;
    }

    public static ItemStack createItem(ItemLike item, List<ItemStack> contents, int size) {
        return MoneyBagItem.createItem(item, new MoneyBagData((List<ItemStack>)ImmutableList.copyOf(InventoryUtil.copyList(contents)), size));
    }

    public static ItemStack createItem(ItemLike item, MoneyBagData data) {
        ItemStack stack = new ItemStack(item);
        if (data.contents().isEmpty()) {
            return stack;
        }
        stack.set(ModDataComponents.MONEY_BAG_CONTENTS, (Object)data);
        return stack;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        float speed;
        ItemAttributeModifiers.Builder attributes = ItemAttributeModifiers.builder();
        int size = MoneyBagItem.getSize(stack);
        float damage = ((Float)LCConfig.SERVER.moneyBagBaseAttack.get()).floatValue() + ((Float)LCConfig.SERVER.moneyBagAttackPerSize.get()).floatValue() * (float)size;
        if (damage != 0.0f) {
            attributes.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if ((speed = ((Float)LCConfig.SERVER.moneyBagBaseAtkSpeed.get()).floatValue() + ((Float)LCConfig.SERVER.moneyBagAtkSpeedPerSize.get()).floatValue() * (float)size) != 0.0f) {
            attributes.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        return attributes.build();
    }
}

