/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot;

import com.google.common.collect.Sets;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class LCLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation ENTITY_DROPS_T1 = LCLootTables.register("loot_addons/entity/tier1");
    public static final ResourceLocation ENTITY_DROPS_T2 = LCLootTables.register("loot_addons/entity/tier2");
    public static final ResourceLocation ENTITY_DROPS_T3 = LCLootTables.register("loot_addons/entity/tier3");
    public static final ResourceLocation ENTITY_DROPS_T4 = LCLootTables.register("loot_addons/entity/tier4");
    public static final ResourceLocation ENTITY_DROPS_T5 = LCLootTables.register("loot_addons/entity/tier5");
    public static final ResourceLocation ENTITY_DROPS_T6 = LCLootTables.register("loot_addons/entity/tier6");
    public static final ResourceLocation BOSS_DROPS_T1 = LCLootTables.register("loot_addons/boss/tier1");
    public static final ResourceLocation BOSS_DROPS_T2 = LCLootTables.register("loot_addons/boss/tier2");
    public static final ResourceLocation BOSS_DROPS_T3 = LCLootTables.register("loot_addons/boss/tier3");
    public static final ResourceLocation BOSS_DROPS_T4 = LCLootTables.register("loot_addons/boss/tier4");
    public static final ResourceLocation BOSS_DROPS_T5 = LCLootTables.register("loot_addons/boss/tier5");
    public static final ResourceLocation BOSS_DROPS_T6 = LCLootTables.register("loot_addons/boss/tier6");
    public static final ResourceLocation CHEST_DROPS_T1 = LCLootTables.register("loot_addons/chest/tier1");
    public static final ResourceLocation CHEST_DROPS_T2 = LCLootTables.register("loot_addons/chest/tier2");
    public static final ResourceLocation CHEST_DROPS_T3 = LCLootTables.register("loot_addons/chest/tier3");
    public static final ResourceLocation CHEST_DROPS_T4 = LCLootTables.register("loot_addons/chest/tier4");
    public static final ResourceLocation CHEST_DROPS_T5 = LCLootTables.register("loot_addons/chest/tier5");
    public static final ResourceLocation CHEST_DROPS_T6 = LCLootTables.register("loot_addons/chest/tier6");
    public static final ResourceLocation ARCHAEOLOGY_VILLAGE_DESERT_BANKER = LCLootTables.register("archaeology/village/desert_banker");
    public static final ResourceLocation ARCHAEOLOGY_VILLAGE_PLAINS_SHOP = LCLootTables.register("archaeology/village/plains_shop");
    public static final ResourceLocation ARCHAEOLOGY_VILLAGE_TAIGA_SHOP = LCLootTables.register("archaeology/village/taiga_shop");
    public static final ResourceLocation ARCHAEOLOGY_VILLAGE_DESERT_SHOP = LCLootTables.register("archaeology/village/desert_shop");
    public static final ResourceLocation ARCHAEOLOGY_ANCIENT_RUINS = LCLootTables.register("archaeology/ancient_city/ancient_ruins");

    private static ResourceLocation register(String id) {
        return LCLootTables.register(VersionUtil.lcResource(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (LOCATIONS.add((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id))) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered LightmansCurrency loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

