/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.impactor.money;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.TextDisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorCurrencyType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.kyori.adventure.key.Key;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class ImpactorMoneyValue
extends MoneyValue {
    private final Currency currency;
    private final BigDecimal value;

    public Currency getImpactorCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    private ImpactorMoneyValue(Currency currency, BigDecimal value) {
        this.currency = Objects.requireNonNull(currency, "Currency Type must not be null!");
        this.value = value;
    }

    @Override
    @Nonnull
    protected String generateUniqueName() {
        return this.generateCustomUniqueName(this.currency.key().toString());
    }

    @Override
    @Nonnull
    protected ResourceLocation getType() {
        return ImpactorCurrencyType.TYPE;
    }

    @Override
    public boolean isEmpty() {
        return this.getCoreValue() <= 0L;
    }

    private static BigDecimal getDecimalNullifier(Currency currency) {
        int decimals = currency.decimals();
        int result = 1;
        while (decimals-- > 0) {
            result *= 10;
        }
        return BigDecimal.valueOf(result);
    }

    @Override
    public long getCoreValue() {
        return Math.max(0L, this.value.multiply(ImpactorMoneyValue.getDecimalNullifier(this.currency)).longValue());
    }

    @Override
    public MutableComponent getText(@Nonnull MutableComponent emptyText) {
        if (this.isEmpty()) {
            return emptyText;
        }
        return LCImpactorCompat.convertComponent(this.currency.format(this.value));
    }

    @Override
    public MoneyValue addValue(@Nonnull MoneyValue addedValue) {
        ImpactorMoneyValue other;
        if (addedValue instanceof ImpactorMoneyValue && (other = (ImpactorMoneyValue)addedValue).getImpactorCurrency().key().equals((Object)this.currency.key())) {
            return ImpactorMoneyValue.of(this.currency, this.value.add(other.value));
        }
        return null;
    }

    @Override
    public boolean containsValue(@Nonnull MoneyValue queryValue) {
        if (queryValue instanceof ImpactorMoneyValue) {
            ImpactorMoneyValue other = (ImpactorMoneyValue)queryValue;
            return this.value.doubleValue() >= other.value.doubleValue();
        }
        return false;
    }

    @Override
    public MoneyValue subtractValue(@Nonnull MoneyValue removedValue) {
        ImpactorMoneyValue other;
        if (removedValue instanceof ImpactorMoneyValue && (other = (ImpactorMoneyValue)removedValue).getImpactorCurrency().key().equals((Object)this.currency.key())) {
            return ImpactorMoneyValue.of(this.currency, this.value.subtract(other.value));
        }
        return null;
    }

    @Override
    public MoneyValue percentageOfValue(int percentage, boolean roundUp) {
        if (percentage == 100) {
            return this;
        }
        if (percentage == 0) {
            return MoneyValue.free();
        }
        BigDecimal mult = BigDecimal.valueOf(percentage).divide(BigDecimal.valueOf(100L), MathContext.UNLIMITED);
        BigDecimal newValue = this.value.multiply(mult);
        return ImpactorMoneyValue.of(this.currency, newValue);
    }

    @Override
    @Nonnull
    public MoneyValue multiplyValue(double multiplier) {
        BigDecimal mult = BigDecimal.valueOf(multiplier);
        BigDecimal newValue = this.value.multiply(mult);
        return ImpactorMoneyValue.of(this.currency, newValue);
    }

    @Override
    @Nonnull
    public List<ItemStack> onBlockBroken(@Nonnull OwnerData owner) {
        PlayerReference player = owner.getPlayerForContext();
        Account account = LCImpactorCompat.getPlayerAccount(player.id, this.currency);
        if (account != null) {
            account.deposit(this.value);
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    @Nonnull
    public MoneyValue getSmallestValue() {
        return this.fromCoreValue(1L);
    }

    @Override
    @Nonnull
    public MoneyValue fromCoreValue(long value) {
        BigDecimal result = BigDecimal.ONE.divide(ImpactorMoneyValue.getDecimalNullifier(this.currency), MathContext.UNLIMITED);
        return ImpactorMoneyValue.of(this.currency, result);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.putString("Currency", this.currency.key().toString());
        tag.putString("Value", this.value.toString());
    }

    @Override
    protected void writeAdditionalToJson(@Nonnull JsonObject json) {
        json.addProperty("Currency", this.currency.key().toString());
        json.addProperty("Value", (Number)this.value);
    }

    @Override
    @Nonnull
    public DisplayEntry getDisplayEntry(@Nullable List<Component> additionalTooltips, boolean tooltipOverride) {
        return TextDisplayEntry.of((Component)this.getText(EasyText.empty()), TextRenderUtil.TextFormatting.create());
    }

    public static MoneyValue load(CompoundTag tag) {
        Key currency = Key.key((String)tag.getString("Currency"), (char)':');
        BigDecimal value = new BigDecimal(tag.getString("Value"));
        return ImpactorMoneyValue.of(currency, value);
    }

    public static MoneyValue load(JsonObject json) {
        Key currency = Key.key((String)GsonHelper.getAsString((JsonObject)json, (String)"Currency"), (char)';');
        BigDecimal value = GsonHelper.getAsBigDecimal((JsonObject)json, (String)"Value");
        return ImpactorMoneyValue.of(currency, value);
    }

    public static MoneyValue of(Key currencyKey, BigDecimal value) {
        return ImpactorMoneyValue.of(EconomyService.instance().currencies().currency(currencyKey).orElse(null), value);
    }

    public static MoneyValue of(Currency currency, BigDecimal value) {
        if (currency == null) {
            return MoneyValue.empty();
        }
        if (value.doubleValue() <= 0.0) {
            return ImpactorMoneyValue.empty();
        }
        return new ImpactorMoneyValue(currency, value);
    }
}

