/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.ItemValidator;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketOpenATM
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketOpenATM> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_open_atm"));
    public static CustomPacket.Handler<CPacketOpenATM> HANDLER = new H();
    private final Item portableATM;

    public CPacketOpenATM(Item portableATM) {
        super(TYPE);
        this.portableATM = portableATM;
    }

    private static void encode(FriendlyByteBuf buffer, CPacketOpenATM message) {
        buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)message.portableATM));
    }

    private static CPacketOpenATM decode(FriendlyByteBuf buffer) {
        return new CPacketOpenATM((Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation()));
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenATM> {
        protected H() {
            super(TYPE, StreamCodec.of(CPacketOpenATM::encode, CPacketOpenATM::decode));
        }

        @Override
        public void handle(CPacketOpenATM message, IPayloadContext context, Player player) {
            if (QuarantineAPI.IsDimensionQuarantined((Entity)player)) {
                EasyText.sendMessage(player, (Component)LCText.MESSAGE_DIMENSION_QUARANTINED_BANK.getWithStyle(ChatFormatting.GOLD));
            } else {
                player.openMenu(PortableATMItem.getMenuProvider(message.portableATM), EasyMenu.encoder(new ItemValidator((ItemLike)message.portableATM)));
            }
        }
    }
}

