/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings;

import com.mojang.datafixers.util.Either;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.EasyListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.list.ListEditBoxOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ItemListOption;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemListSettings
extends EasyListSettings<Item, ItemListOption> {
    public ItemListSettings(ItemListOption option, Consumer<Object> changeHandler) {
        super(option, changeHandler);
    }

    @Override
    protected Item getBackupValue() {
        return Items.f_41852_;
    }

    @Override
    protected Item getNewEntryValue() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!((ItemListOption)this.option).allowedListValue(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    protected Either<Item, Void> tryCastValue(Object newValue) {
        if (newValue instanceof ItemLike) {
            ItemLike item = (ItemLike)newValue;
            Item i = item.m_5456_();
            if (!((ItemListOption)this.option).filter.test(i)) {
                return Either.right(null);
            }
            return Either.left((Object)i);
        }
        return Either.right(null);
    }

    private Consumer<String> tryParseItem(Consumer<Object> consumer) {
        return string -> {
            try {
                Item item;
                ResourceLocation id = VersionUtil.parseResource(string);
                if (ForgeRegistries.ITEMS.containsKey(id) && ((ItemListOption)this.option).allowedListValue(item = (Item)ForgeRegistries.ITEMS.getValue(id))) {
                    consumer.accept(item);
                }
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        };
    }

    @Override
    public AbstractWidget buildEntry(int index) {
        return ListEditBoxOption.builder(this.option, index, this).inputBoxSetup(handler -> TextInputUtil.stringBuilder().startingString(ForgeRegistries.ITEMS.getKey((Object)((Item)this.getValue(index))).toString()).handler(this.tryParseItem((Consumer<Object>)handler))).optionChangeHandler(editBox -> editBox.m_94144_(ForgeRegistries.ITEMS.getKey((Object)((Item)this.getValue(index))).toString())).build();
    }
}

