/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.player;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.data.ClientPlayerNameCache;
import io.github.lightman314.lightmanscurrency.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerReference {
    public static final PlayerReference NULL = new PlayerReference(new UUID(0L, 0L), "NULL");
    public final UUID id;
    private boolean forceName = false;
    private final String name;

    public String getName(boolean isClient) {
        if (this.forceName) {
            return this.name;
        }
        if (isClient) {
            String n = ClientPlayerNameCache.lookupName(this.id);
            return Objects.requireNonNullElse(n, this.name);
        }
        String n = PlayerReference.getPlayerName(this.id);
        if (n == null || n.isBlank()) {
            return this.name;
        }
        return n;
    }

    public MutableComponent getNameComponent(boolean isClient) {
        return Component.m_237113_((String)this.getName(isClient));
    }

    public ItemStack getSkull(boolean isClient) {
        return ItemStackHelper.skullForPlayer(this.getName(isClient));
    }

    private PlayerReference(UUID playerID, String name) {
        this.id = playerID;
        this.name = name;
    }

    public PlayerReference copyWithName(String name) {
        PlayerReference copy = new PlayerReference(this.id, name);
        copy.forceName = true;
        return copy;
    }

    public boolean is(PlayerReference player) {
        if (player == null) {
            return false;
        }
        return this.is(player.id);
    }

    public boolean isExact(PlayerReference player) {
        if (player == null) {
            return false;
        }
        return this.is(player.id) && !this.forceName && !player.forceName;
    }

    public boolean is(GameProfile profile) {
        return this.is(profile.getId());
    }

    public boolean is(UUID entityID) {
        if (entityID == null) {
            return false;
        }
        return entityID.equals(this.id);
    }

    public boolean is(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_20148_().equals(this.id);
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public Player getPlayer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_6846_().m_11259_(this.id);
        }
        return null;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("id", this.id);
        compound.m_128359_("name", this.getName(false));
        if (this.forceName) {
            compound.m_128379_("forcedname", this.forceName);
        }
        return compound;
    }

    public JsonObject saveAsJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        json.addProperty("name", this.getName(false));
        return json;
    }

    public void encode(FriendlyByteBuf buffer, boolean isClient) {
        buffer.m_130077_(this.id);
        buffer.m_130070_(this.getName(isClient));
    }

    public static PlayerReference load(CompoundTag compound) {
        try {
            UUID id = compound.m_128342_("id");
            String name = compound.m_128461_("name");
            PlayerReference pr = PlayerReference.of(id, name);
            if (compound.m_128441_("forcedname")) {
                pr.forceName = compound.m_128471_("forcedname");
            }
            return pr;
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from tag.", e);
            return null;
        }
    }

    public static PlayerReference load(JsonElement json) {
        try {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return PlayerReference.of(false, json.getAsString());
            }
            JsonObject j = json.getAsJsonObject();
            UUID id = UUID.fromString(j.get("id").getAsString());
            String name = j.get("name").getAsString();
            return PlayerReference.of(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from JsonObject", e);
            return null;
        }
    }

    public static PlayerReference decode(FriendlyByteBuf buffer) {
        return PlayerReference.of(buffer.m_130259_(), buffer.m_130277_());
    }

    public static void saveList(CompoundTag compound, List<PlayerReference> playerList, String tag) {
        ListTag list = new ListTag();
        for (PlayerReference playerReference : playerList) {
            if (playerReference == null) continue;
            list.add((Object)playerReference.save());
        }
        compound.m_128365_(tag, (Tag)list);
    }

    public static JsonArray saveJsonList(List<PlayerReference> playerList) {
        JsonArray array = new JsonArray();
        for (PlayerReference playerReference : playerList) {
            if (playerReference == null) continue;
            array.add((JsonElement)playerReference.saveAsJson());
        }
        return array;
    }

    public static List<PlayerReference> loadList(CompoundTag compound, String tag) {
        ArrayList<PlayerReference> playerList = new ArrayList<PlayerReference>();
        if (compound.m_128425_(tag, 9)) {
            ListTag list = compound.m_128437_(tag, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag thisCompound = list.m_128728_(i);
                PlayerReference player = PlayerReference.load(thisCompound);
                if (player == null) continue;
                playerList.add(player);
            }
        }
        return playerList;
    }

    public static PlayerReference of(@Nonnull UUID playerID, String name) {
        if (playerID == null) {
            throw new RuntimeException("Cannot make a PlayerReference from a null player ID!");
        }
        return new PlayerReference(playerID, name);
    }

    public static PlayerReference of(GameProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        return PlayerReference.of(playerProfile.getId(), playerProfile.getName());
    }

    public static PlayerReference of(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return PlayerReference.of(player);
        }
        return null;
    }

    public static PlayerReference of(Player player) {
        if (player == null) {
            return null;
        }
        return PlayerReference.of(player.m_36316_());
    }

    public static PlayerReference of(boolean isClient, String playerName) {
        if (playerName.isBlank()) {
            return null;
        }
        if (isClient) {
            UUID id = ClientPlayerNameCache.lookupID(playerName);
            if (id != null) {
                return PlayerReference.of(id, playerName);
            }
            return null;
        }
        UUID playerID = PlayerReference.getPlayerID(playerName);
        if (playerID != null) {
            return PlayerReference.of(playerID, playerName);
        }
        return null;
    }

    public static PlayerReference dummy(String dummyName) {
        PlayerReference pr = new PlayerReference(new UUID(0L, 0L), dummyName);
        pr.forceName = true;
        return pr;
    }

    public static boolean isInList(List<PlayerReference> list, Entity entry) {
        if (entry != null) {
            return PlayerReference.isInList(list, entry.m_20148_());
        }
        return false;
    }

    public static boolean isInList(List<PlayerReference> list, PlayerReference entry) {
        if (entry != null) {
            return PlayerReference.isInList(list, entry.id);
        }
        return false;
    }

    public static boolean isInList(List<PlayerReference> list, UUID id) {
        for (PlayerReference player : list) {
            if (player == null || !player.is(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean addToList(List<PlayerReference> list, PlayerReference entry) {
        if (!PlayerReference.isInList(list, entry)) {
            list.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeFromList(List<PlayerReference> list, PlayerReference entry) {
        if (entry != null) {
            return PlayerReference.removeFromList(list, entry.id);
        }
        return false;
    }

    public static boolean removeFromList(List<PlayerReference> list, UUID id) {
        for (int i = 0; i < list.size(); ++i) {
            PlayerReference pr = list.get(i);
            if (pr == null || !pr.is(id)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static String getPlayerName(UUID playerID) {
        try {
            GameProfile profile;
            String name = UsernameCache.getLastKnownUsername((UUID)playerID);
            if (name != null) {
                return name;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (profile = (GameProfile)server.m_129927_().m_11002_(playerID).orElse(null)) != null) {
                return profile.getName();
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting player name.", t);
        }
        return null;
    }

    public static UUID getPlayerID(String playerName) {
        try {
            GameProfile profile;
            for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
                if (!((String)entry.getValue()).equalsIgnoreCase(playerName)) continue;
                return (UUID)entry.getKey();
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (profile = (GameProfile)server.m_129927_().m_10996_(playerName).orElse(null)) != null) {
                return profile.getId();
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting player ID from name.", t);
        }
        return null;
    }

    static {
        PlayerReference.NULL.forceName = true;
    }
}

