/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;

public class TaxesPaidNotification
extends SingleLineNotification {
    public static final NotificationType<TaxesPaidNotification> TYPE = new NotificationType(VersionUtil.lcResource("taxes_paid"), TaxesPaidNotification::new);
    private MoneyValue amount = MoneyValue.empty();
    private NotificationCategory category = NotificationCategory.GENERAL;

    private TaxesPaidNotification() {
    }

    private TaxesPaidNotification(MoneyValue amount, NotificationCategory category) {
        this.amount = amount;
        this.category = category;
    }

    public static NonNullSupplier<Notification> create(MoneyValue amount, NotificationCategory category) {
        return () -> new TaxesPaidNotification(amount, category);
    }

    @Nonnull
    protected NotificationType<TaxesPaidNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public Component getMessage() {
        if (this.amount.isEmpty()) {
            return LCText.NOTIFICATION_TAXES_PAID_NULL.get(new Object[0]);
        }
        return LCText.NOTIFICATION_TAXES_PAID.get(this.amount.getText());
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Amount", (Tag)this.amount.save());
        compound.m_128365_("Category", (Tag)this.category.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.amount = MoneyValue.load(compound.m_128469_("Amount"));
        this.category = NotificationAPI.getApi().LoadCategory(compound.m_128469_("Category"));
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof TaxesPaidNotification) {
            TaxesPaidNotification tpn = (TaxesPaidNotification)other;
            return tpn.amount.equals(this.amount) && tpn.category.matches(this.category);
        }
        return false;
    }
}

