/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamStatsTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TeamStatsClientTab
extends TeamManagementClientTab<TeamStatsTab>
implements IScrollable {
    private static final int LINE_COUNT = 10;
    private static final int LINE_SIZE = 10;
    private static final int START_POS = 37;
    private int scroll = 0;
    private EasyButton buttonClear;

    public TeamStatsClientTab(@Nonnull Object screen, @Nonnull TeamStatsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_PRICE_FLUCTUATION;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TEAM_STATS.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.buttonClear = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 10))).width(screenArea.width - 20)).text(LCText.BUTTON_TRADER_STATS_CLEAR).pressAction(() -> ((TeamStatsTab)this.commonTab).ClearStats(Screen.m_96638_()))).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 10 - 8, 37))).height(100).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.offsetPosition(0, 37).ofSize(screenArea.width, 100))).listener(this).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.validateScroll();
        int yPos = 37;
        List<MutableComponent> lines = this.getLines();
        if (lines.isEmpty()) {
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (Component)LCText.GUI_TRADER_STATS_EMPTY.get(new Object[0]), 10, ((TeamManagerScreen)this.screen).getXSize() - 20, yPos, 100, 0x404040);
        } else {
            for (int i = this.scroll; i < this.scroll + 10 && i < lines.size(); ++i) {
                gui.drawString((Component)lines.get(i), 10, yPos, 0x404040);
                yPos += 10;
            }
        }
    }

    @Override
    public void tick() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        this.buttonClear.f_93623_ = team != null && team.isAdmin(((TeamManagementMenu)this.menu).player);
    }

    private List<MutableComponent> getLines() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return new ArrayList<MutableComponent>();
        }
        return team.getStats().getDisplayLines();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(10, this.getLines().size());
    }
}

