/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.scroll;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FlexibleWidthSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.HorizontalSliceSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HorizScrollBarWidget
extends EasyWidget
implements IMouseListener,
IPreRender {
    public static final FlexibleWidthSprite BACKGROUND_SPRITE = new HorizontalSliceSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_horiz_background"), 128, 8), 8);
    public static final FixedSizeSprite KNOB_SPRITE = new NormalSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_horiz_knob"), 29, 8));
    public static final FixedSizeSprite SMALL_KNOB_SPRITE = new NormalSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_horiz_smallknob"), 9, 8));
    public static final FixedSizeSprite SLIDER_SPRITE = new NormalSprite(SpriteSource.create(VersionUtil.lcResource("common/widgets/scrollbar_horiz_slider"), 5, 12));
    public static final int HEIGHT = 8;
    private final IScrollable scrollable;
    private final FixedSizeSprite knobSprite;
    public boolean isDragging = false;

    private HorizScrollBarWidget(Builder builder) {
        super(builder);
        this.scrollable = builder.scrollable;
        this.knobSprite = builder.knobSprite;
    }

    public boolean visible() {
        return this.f_93624_ && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    @Override
    protected void renderTick() {
        if (!this.visible() && this.isDragging) {
            this.isDragging = false;
        }
    }

    @Override
    public void renderWidget(EasyGuiGraphics gui) {
        if (!this.visible()) {
            return;
        }
        gui.resetColor();
        BACKGROUND_SPRITE.render(gui, 0, 0, this.f_93618_);
        int knobPosition = this.isDragging ? MathUtil.clamp(gui.mousePos.x - this.m_252754_() - this.getKnobWidth() / 2, 0, this.f_93618_ - this.getKnobWidth()) : this.getNaturalKnobPosition();
        int knobOffset = (8 - this.knobSprite.getHeight()) / 2;
        this.knobSprite.render(gui, knobPosition, knobOffset);
    }

    @Override
    public void preRender(EasyGuiGraphics gui) {
        if (this.isDragging) {
            this.dragKnob(gui.mousePos.x);
        }
    }

    private int getKnobWidth() {
        return this.knobSprite.getWidth();
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.f_93618_ - this.getKnobWidth()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    protected void dragKnob(double mouseX) {
        if (!this.visible()) {
            this.isDragging = false;
            return;
        }
        int scroll = this.getScrollFromMouse(mouseX);
        if (this.scrollable.currentScroll() != scroll) {
            this.scrollable.setScroll(scroll);
        }
    }

    private int getScrollFromMouse(double mouseX) {
        if ((mouseX -= (double)this.getKnobWidth() / 2.0) <= (double)this.m_252754_()) {
            return this.scrollable.getMinScroll();
        }
        if (mouseX >= (double)(this.m_252754_() + this.f_93618_ - this.getKnobWidth())) {
            return this.scrollable.getMaxScroll();
        }
        int deltaScroll = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (deltaScroll <= 0) {
            return Integer.MIN_VALUE;
        }
        double sectionWidth = (double)(this.f_93618_ - this.getKnobWidth()) / (double)deltaScroll;
        double xPos = (double)this.m_252754_() - sectionWidth / 2.0;
        for (int i = this.scrollable.getMinScroll(); i <= this.scrollable.getMaxScroll(); ++i) {
            if (mouseX >= xPos && mouseX < xPos + sectionWidth) {
                return i;
            }
            xPos += sectionWidth;
        }
        LightmansCurrency.LogWarning("Error getting scroll from mouse position.");
        return this.scrollable.getMinScroll();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.m_5953_(mouseX, mouseY) && this.visible() && button == 0) {
            this.isDragging = true;
            this.dragKnob(mouseX);
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && this.visible() && button == 0) {
            this.dragKnob(mouseX);
            this.isDragging = false;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private FixedSizeSprite knobSprite = KNOB_SPRITE;
        private IScrollable scrollable = null;

        private Builder() {
            super(20, 8);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public <T extends EasyWidget> Builder onTop(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(0, -8))).width(widget.m_5711_());
        }

        public <T extends EasyWidget> Builder onBottom(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(0, widget.m_93694_()))).width(widget.m_5711_());
        }

        public Builder scrollable(IScrollable scrollable) {
            this.scrollable = scrollable;
            return this;
        }

        public Builder smallKnob() {
            return this.customKnob(SMALL_KNOB_SPRITE);
        }

        public Builder sliderKnob() {
            return this.customKnob(SLIDER_SPRITE);
        }

        public Builder customKnob(FixedSizeSprite knobSprite) {
            this.knobSprite = knobSprite;
            return this;
        }

        public HorizScrollBarWidget build() {
            return new HorizScrollBarWidget(this);
        }
    }
}

