/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.gamerule;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ModGameRules {
    private static final List<RuleData<?>> GAME_RULES = Lists.newArrayList();
    public static final GameRules.Key<GameRules.BooleanValue> KEEP_WALLET = ModGameRules.register("keepWallet", GameRules.Category.PLAYER, GameRules.BooleanValue.m_46250_((boolean)false));
    public static final GameRules.Key<GameRules.IntegerValue> COIN_DROP_PERCENT = ModGameRules.register("coinDropPercent", GameRules.Category.PLAYER, GameRules.IntegerValue.m_46294_((int)0, ModGameRules.keepWithinLimits(0, 100)));

    private static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
        if (ruleType == null) {
            return null;
        }
        GameRules.Key ruleKey = new GameRules.Key(name, category);
        GAME_RULES.add(new RuleData<T>(name, category, ruleType));
        return ruleKey;
    }

    public static <T extends GameRules.Value<T>> T getCustomValue(@Nonnull Level level, @Nullable GameRules.Key<T> ruleKey) {
        if (ruleKey == null) {
            return null;
        }
        return (T)level.m_46469_().m_46170_(ruleKey);
    }

    public static boolean safeGetCustomBool(@Nonnull Level level, @Nullable GameRules.Key<GameRules.BooleanValue> ruleKey, boolean defaultValue) {
        GameRules.BooleanValue ruleVal = ModGameRules.getCustomValue(level, ruleKey);
        if (ruleVal != null) {
            return ruleVal.m_46223_();
        }
        return defaultValue;
    }

    public static int safeGetCustomInt(@Nonnull Level level, @Nullable GameRules.Key<GameRules.IntegerValue> ruleKey, int defaultValue) {
        GameRules.IntegerValue ruleVal = ModGameRules.getCustomValue(level, ruleKey);
        if (ruleVal != null) {
            return ruleVal.m_46288_();
        }
        return defaultValue;
    }

    public static void registerRules() {
        GAME_RULES.forEach(rule -> GameRules.m_46189_((String)rule.name, (GameRules.Category)rule.category, rule.ruleType));
        GAME_RULES.clear();
    }

    public static BiConsumer<MinecraftServer, GameRules.IntegerValue> keepWithinLimits(int lowerLimit, int upperLimit) {
        return (s, v) -> {
            int newValue;
            int oldValue = v.m_46288_();
            if (oldValue != (newValue = MathUtil.clamp(oldValue, lowerLimit, upperLimit))) {
                v.m_151489_(newValue, null);
            }
        };
    }

    private record RuleData<T extends GameRules.Value<T>>(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
    }
}

