/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.FreezerDoorData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.ItemPositionDataEntry;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.ShowInCreative;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.TooltipInfo;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.client.generators.ModelVariantProvider;
import io.github.lightman314.lightmanscurrency.datagen.util.ColorHelper;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class LCModelVariantProvider
extends ModelVariantProvider {
    public LCModelVariantProvider(PackOutput output) {
        super(output, "lightmanscurrency");
    }

    @Override
    protected void addEntries() {
        ResourceLocation DISPLAY_CASE_GLASSLESS = VersionUtil.lcResource("display_case/glassless");
        this.add(DISPLAY_CASE_GLASSLESS, ModelVariant.builder().withName((Component)LCText.BLOCK_VARIANT_DEFAULT.get(new Object[0])).withItem(VersionUtil.lcResource("block/display_case/glassless/base")).withModel(VersionUtil.lcResource("block/display_case/glassless/base")).withProperty(VariantProperties.ITEM_POSITION_DATA, ItemPositionDataEntry.create(VersionUtil.lcResource("display_case_open"))).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_GLASSLESS)).asDummy().build());
        ModBlocks.DISPLAY_CASE.forEach((color, block) -> this.add("display_case/glassless/" + color.getResourceSafeName(), ModelVariant.builder().withParent(DISPLAY_CASE_GLASSLESS).withTarget((Supplier<? extends Block>)block).withTexture("wool", ColorHelper.GetWoolTextureOfColor(color)).build()));
        this.add("armor_display/glassless", ModelVariant.builder().withTarget((Supplier<? extends Block>)ModBlocks.ARMOR_DISPLAY).withName((Component)LCText.BLOCK_VARIANT_DEFAULT.get(new Object[0])).withItem(VersionUtil.lcResource("block/armor_display/glassless/item")).withModel(VersionUtil.lcResource("block/armor_display/glassless/bottom")).withModel(VersionUtil.lcResource("block/armor_display/glassless/top")).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_GLASSLESS)).build());
        ResourceLocation SKIN_DEFAULT = VersionUtil.lcResource("armor_display/skin_default");
        ResourceLocation SKIN_GLASSLESS = VersionUtil.lcResource("armor_display/skin_glassless");
        this.add(SKIN_DEFAULT, ModelVariant.builder().withTarget((Supplier<? extends Block>)ModBlocks.ARMOR_DISPLAY).withItem(VersionUtil.lcResource("block/armor_display/skin/item")).withModel(VersionUtil.lcResource("block/armor_display/skin/bottom"), VersionUtil.lcResource("block/armor_display/skin/top")).withProperty(VariantProperties.SHOW_IN_CREATIVE).asDummy().build());
        this.add(SKIN_GLASSLESS, ModelVariant.builder().withTarget((Supplier<? extends Block>)ModBlocks.ARMOR_DISPLAY).withItem(VersionUtil.lcResource("block/armor_display/skin/glassless/item")).withModel(VersionUtil.lcResource("block/armor_display/skin/glassless/bottom"), VersionUtil.lcResource("block/armor_display/skin/glassless/top")).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_GLASSLESS)).asDummy().build());
        for (int i = 1; i <= 5; ++i) {
            MutableComponent name = LCText.BLOCK_VARIANT_ARMOR_SKIN.get(LCText.BLOCK_VARIANT_ARMOR_SKINS.get(i - 1).get(new Object[0]));
            this.add("armor_display/skin/" + i + "/default", ModelVariant.builder().withParent(SKIN_DEFAULT).withName((Component)name).withTexture("skin", VersionUtil.lcResource("block/armor_display/skin" + i)).build());
            this.add("armor_display/skin/" + i + "/glassless", ModelVariant.builder().withParent(SKIN_GLASSLESS).withName((Component)name).withTexture("skin", VersionUtil.lcResource("block/armor_display/skin" + i)).build());
        }
        this.add("armor_display/skin/herobrine/default", ModelVariant.builder().withParent(SKIN_DEFAULT).withName((Component)LCText.BLOCK_VARIANT_ARMOR_SKIN.get(LCText.BLOCK_VARIANT_ARMOR_SKIN_HEROBRINE.get(new Object[0]))).withTexture("skin", VersionUtil.lcResource("block/armor_display/skin_herobrine")).withProperty(VariantProperties.HIDDEN).withProperty(VariantProperties.SHOW_IN_CREATIVE, ShowInCreative.LOCKED).build());
        this.add("armor_display/skin/herobrine/glassless", ModelVariant.builder().withParent(SKIN_GLASSLESS).withName((Component)LCText.BLOCK_VARIANT_ARMOR_SKIN.get(LCText.BLOCK_VARIANT_ARMOR_SKIN_HEROBRINE.get(new Object[0]))).withTexture("skin", VersionUtil.lcResource("block/armor_display/skin_herobrine")).withProperty(VariantProperties.HIDDEN).withProperty(VariantProperties.SHOW_IN_CREATIVE, ShowInCreative.LOCKED).build());
        ResourceLocation FOOTLESS_VENDING_MACHINE = VersionUtil.lcResource("vending_machine/footless");
        this.add(FOOTLESS_VENDING_MACHINE, ModelVariant.builder().withName((Component)LCText.BLOCK_VARIANT_DEFAULT.get(new Object[0])).withItem(VersionUtil.lcResource("block/vending_machine/footless/base_item")).withModel(VersionUtil.lcResource("block/vending_machine/footless/base_bottom"), VersionUtil.lcResource("block/vending_machine/footless/base_top")).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_FOOTLESS)).asDummy().build());
        ModBlocks.VENDING_MACHINE.forEach((color, block) -> this.add("vending_machine/footless/" + color.getResourceSafeName(), ModelVariant.builder().withParent(FOOTLESS_VENDING_MACHINE).withTarget((Supplier<? extends Block>)block).withTexture("exterior", VersionUtil.lcResource("block/vending_machine/footless/" + color.getResourceSafeName() + "_exterior")).withTexture("interior", VersionUtil.lcResource("block/vending_machine/footless/" + color.getResourceSafeName() + "_interior")).build()));
        ResourceLocation FOOTLESS_LARGE_VENDING_MACHINE = VersionUtil.lcResource("large_vending_machine/footless");
        this.add(FOOTLESS_LARGE_VENDING_MACHINE, ModelVariant.builder().withName((Component)LCText.BLOCK_VARIANT_DEFAULT.get(new Object[0])).withItem(VersionUtil.lcResource("block/large_vending_machine/footless/base_item")).withModel(VersionUtil.lcResource("block/large_vending_machine/footless/base_bottom_left"), VersionUtil.lcResource("block/large_vending_machine/footless/base_bottom_right"), VersionUtil.lcResource("block/large_vending_machine/footless/base_top_left"), VersionUtil.lcResource("block/large_vending_machine/footless/base_top_right")).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_FOOTLESS)).asDummy().build());
        ModBlocks.VENDING_MACHINE_LARGE.forEach((color, block) -> this.add("large_vending_machine/footless/" + color.getResourceSafeName(), ModelVariant.builder().withParent(FOOTLESS_LARGE_VENDING_MACHINE).withTarget((Supplier<? extends Block>)block).withTexture("exterior", VersionUtil.lcResource("block/large_vending_machine/footless/" + color.getResourceSafeName() + "_exterior")).withTexture("interior", VersionUtil.lcResource("block/large_vending_machine/footless/" + color.getResourceSafeName() + "_interior")).build()));
        ResourceLocation FREEZER_INVERTED = VersionUtil.lcResource("freezer/inverted/base");
        this.add(FREEZER_INVERTED, ModelVariant.builder().withName((Component)LCText.BLOCK_VARIANT_DEFAULT.get(new Object[0])).withModel(VersionUtil.lcResource("block/freezer/base_bottom"), VersionUtil.lcResource("block/freezer/base_top"), VersionUtil.lcResource("block/freezer/inverted/door")).withItem(VersionUtil.lcResource("block/freezer/inverted/item")).withProperty(VariantProperties.FREEZER_DOOR_DATA, new FreezerDoorData(-90.0f, 0.03125f, 0.21875f)).withProperty(VariantProperties.TOOLTIP_INFO, TooltipInfo.ofModifier(LCText.BLOCK_VARIANT_MODIFIER_INVERTED)).asDummy().build());
        ModBlocks.FREEZER.forEach((color, block) -> this.add("freezer/inverted/" + color.getResourceSafeName(), ModelVariant.builder().withParent(FREEZER_INVERTED).withTarget((Supplier<? extends Block>)block).withTexture("concrete", ColorHelper.GetConcreteTextureOfColor(color)).build()));
        ModBlocks.CARD_DISPLAY.forEachKey1(wood -> {
            WoodData data = WoodDataHelper.get(wood);
            if (data != null) {
                this.createForCardDisplay(VersionUtil.lcResource("block/card_display/base_inner_corner"), (Component)LCText.BLOCK_VARIANT_INNER_CORNER.get(new Object[0]), VersionUtil.lcResource("variants/card_display/inner_corner"), "inner_corner");
                this.createForCardDisplay(VersionUtil.lcResource("block/card_display/base_outer_corner"), (Component)LCText.BLOCK_VARIANT_OUTER_CORNER.get(new Object[0]), VersionUtil.lcResource("variants/card_display/outer_corner"), "outer_corner");
            }
        });
    }

    private void createForCardDisplay(ResourceLocation model, Component name, ResourceLocation itemPosition, String id) {
        ResourceLocation base = VersionUtil.lcResource("card_display/" + id + "/base");
        this.add(base, ModelVariant.builder().withModel(model).withItem(model).withName(name).withProperty(VariantProperties.ITEM_POSITION_DATA, ItemPositionDataEntry.create(itemPosition)).asDummy().build());
        ModBlocks.CARD_DISPLAY.forEachKey1(wood -> {
            WoodData data = WoodDataHelper.get(wood);
            if (data != null) {
                this.createCardDisplayChild(base, (WoodType)wood, data, id);
            }
        });
    }

    private void createCardDisplayChild(ResourceLocation parent, WoodType woodType, WoodData data, String id) {
        ResourceLocation base = VersionUtil.lcResource(woodType.generateResourceLocation("card_display/" + id + "/", "/base"));
        this.add(base, ModelVariant.builder().withParent(parent).withTexture("log", data.logSideTexture).withTexture("logtop", data.logTopTexture).withTexture("plank", data.plankTexture).asDummy().build());
        for (Color color : Color.values()) {
            this.add(woodType.generateResourceLocation("card_display/" + id + "/", "/" + color.getResourceSafeName()), ModelVariant.builder().withTarget(ModBlocks.CARD_DISPLAY.get(woodType, color)).withParent(base).withTexture("wool", ColorHelper.GetWoolTextureOfColor(color)).build());
        }
    }
}

