/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.events.TraderEvent;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.attachments.builtin.ExternalAuthorizationAttachment;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.SlotMachineTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.TraderPeripheralSource;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.CashRegisterPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.TerminalPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.InputTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.auction.AuctionHousePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.gacha_machine.GachaMachinePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.item.ItemTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.paygate.PaygatePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.slot_machine.SlotMachinePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.pocket_upgrades.LCPocketUpgrades;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class LCComputerHelper {
    public static List<TraderPeripheralSource> peripheralSources = new ArrayList<TraderPeripheralSource>();

    public static void setup(IEventBus modBus) {
        LCPocketUpgrades.init(modBus);
        modBus.addListener(LCComputerHelper::registerPeripheralProviders);
        MinecraftForge.EVENT_BUS.addListener(LCComputerHelper::addTraderAttachments);
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.dataOnly(trader -> {
            if (trader instanceof AuctionHouseTrader) {
                return AuctionHousePeripheral.INSTANCE;
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof ItemTraderBlockEntity) {
                ItemTraderBlockEntity itbe = (ItemTraderBlockEntity)be;
                return new ItemTraderPeripheral(itbe);
            }
            return null;
        }, trader -> {
            if (trader instanceof ItemTraderData) {
                ItemTraderData itd = (ItemTraderData)trader;
                return new ItemTraderPeripheral(itd);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.blockOnly(be -> {
            if (be instanceof PaygateBlockEntity) {
                PaygateBlockEntity paygate = (PaygateBlockEntity)be;
                return new PaygatePeripheral(paygate);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof GachaMachineBlockEntity) {
                GachaMachineBlockEntity gacha = (GachaMachineBlockEntity)be;
                return new GachaMachinePeripheral(gacha);
            }
            return null;
        }, trader -> {
            if (trader instanceof GachaTrader) {
                GachaTrader gacha = (GachaTrader)trader;
                return new GachaMachinePeripheral(gacha);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof SlotMachineTraderBlockEntity) {
                SlotMachineTraderBlockEntity slotMachine = (SlotMachineTraderBlockEntity)be;
                return new SlotMachinePeripheral(slotMachine);
            }
            return null;
        }, trader -> {
            if (trader instanceof SlotMachineTraderData) {
                SlotMachineTraderData slotMachine = (SlotMachineTraderData)trader;
                return new SlotMachinePeripheral(slotMachine);
            }
            return null;
        }));
    }

    public static void registerTraderPeripheralSource(TraderPeripheralSource source) {
        if (!peripheralSources.contains(source)) {
            peripheralSources.add(source);
        }
    }

    public static LCPeripheral getPeripheral(TraderBlockEntity<?> be) {
        for (TraderPeripheralSource source : peripheralSources) {
            LCPeripheral result = source.tryCreate(be);
            if (result == null) continue;
            return result;
        }
        if (be.getTraderData() instanceof InputTraderData) {
            return InputTraderPeripheral.createSimpleInput(be);
        }
        return TraderPeripheral.createSimple(be);
    }

    public static LCPeripheral getPeripheral(TraderData trader) {
        for (TraderPeripheralSource source : peripheralSources) {
            LCPeripheral result = source.tryCreate(trader);
            if (result == null) continue;
            return result;
        }
        if (trader instanceof InputTraderData) {
            InputTraderData it = (InputTraderData)trader;
            return InputTraderPeripheral.createSimpleInput(it);
        }
        return TraderPeripheral.createSimple(trader);
    }

    private static void registerPeripheralProviders(FMLCommonSetupEvent event) {
        ForgeComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new PeripheralProvider());
    }

    private static void addTraderAttachments(TraderEvent.RegisterAttachmentEvent event) {
        if (event.getTrader() instanceof AuctionHouseTrader) {
            return;
        }
        event.addAttachment(ExternalAuthorizationAttachment.TYPE);
    }

    private static class PeripheralProvider
    implements IPeripheralProvider {
        private PeripheralProvider() {
        }

        public LazyOptional<IPeripheral> getPeripheral(Level level, BlockPos blockPos, Direction direction) {
            BlockState state = level.m_8055_(blockPos);
            Block block = state.m_60734_();
            if (block instanceof TerminalBlock) {
                TerminalBlock terminal = (TerminalBlock)block;
                return LazyOptional.of(TerminalPeripheral::new);
            }
            BlockEntity be = level.m_7702_(blockPos);
            if (be instanceof CapabilityInterfaceBlockEntity) {
                CapabilityInterfaceBlockEntity cap = (CapabilityInterfaceBlockEntity)be;
                be = cap.tryGetCoreBlockEntity();
            }
            if (be instanceof TraderBlockEntity) {
                TraderBlockEntity trader = (TraderBlockEntity)be;
                LCPeripheral result = LCComputerHelper.getPeripheral(trader);
                if (result == null) {
                    return LazyOptional.empty();
                }
                return LazyOptional.of(() -> PeripheralProvider.lambda$getPeripheral$0((IPeripheral)result));
            }
            if (be instanceof AuctionStandBlockEntity) {
                AuctionStandBlockEntity ah = (AuctionStandBlockEntity)be;
                if (((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
                    return LazyOptional.of(() -> AuctionHousePeripheral.INSTANCE);
                }
            }
            if (be instanceof CashRegisterBlockEntity) {
                CashRegisterBlockEntity cr = (CashRegisterBlockEntity)be;
                return LazyOptional.of(() -> new CashRegisterPeripheral(cr));
            }
            return LazyOptional.empty();
        }

        private static /* synthetic */ IPeripheral lambda$getPeripheral$0(IPeripheral result) {
            return result;
        }
    }
}

