/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.client.screen;

import com.pla.pladailyboss.data.BossEntry;
import com.pla.pladailyboss.enums.BossEntryState;
import com.pla.pladailyboss.network.AskForDataMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BossScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static BossScreen instance;
    private static final String posterPath = "textures/gui/entity_posters/";
    private static final ResourceLocation TITLE;
    private static final ResourceLocation BACKGROUND;
    private static final ResourceLocation FRAME;
    private int currentPage;
    private int totalPages;
    private Button pageButton;
    private List<BossEntry> entityIdStrings;
    private static final int BOX_WIDTH = 90;
    private static final int BOX_HEIGHT = 120;
    private static final int GUI_WIDTH = 512;
    private static final int GUI_HEIGHT = 320;
    private static final int PADDING_HORIZONTAL = 20;
    private static final int PADDING_VERTICAL = 5;
    private static final int BUTTON_SIZE = 20;

    public BossScreen() {
        super((Component)Component.translatable((String)"gui.pladailyboss.boss_screen"));
        instance = this;
        PacketDistributor.sendToServer((CustomPacketPayload)new AskForDataMessage(""), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static BossScreen getInstance() {
        return instance;
    }

    public void setEntityIdStrings(List<BossEntry> entityIdStrings) {
        this.entityIdStrings = entityIdStrings;
        this.init();
    }

    protected void init() {
        if (this.entityIdStrings == null) {
            return;
        }
        this.clearWidgets();
        super.init();
        int bgLeft = (this.width - 512) / 2;
        int bgTop = (this.height - 320) / 2;
        int bgRight = bgLeft + 512;
        int bgBottom = bgTop + 320;
        int bgWidth = 512;
        int maxColumns = Math.max(1, (bgWidth + 20) / 110);
        int maxRows = Math.max(1, 2);
        int entitiesPerPage = maxRows * maxColumns;
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.entityIdStrings.size() / (double)entitiesPerPage));
        this.currentPage = Math.max(1, Math.min(this.currentPage, this.totalPages));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), this::handlePrevPage).bounds(bgRight - 80 - 20 - 30, bgBottom - 30, 20, 20).build());
        this.pageButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.currentPage + "/" + this.totalPages)), this::doNothing).bounds(bgRight - 60 - 20 - 30, bgBottom - 30, 40, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), this::handleNextPage).bounds(bgRight - 20 - 20 - 30, bgBottom - 30, 20, 20).build());
    }

    public boolean textureExists(ResourceLocation location) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        return resourceManager.getResource(location).isPresent();
    }

    private void drawEntityCard(GuiGraphics guiGraphics, int x, int y, BossEntry bossEntry) {
        String prefixImage = bossEntry.state == BossEntryState.DEFEATED ? "_enabled.png" : (bossEntry.state == BossEntryState.NOT_INSTALLED ? "_missing.png" : "_disabled.png");
        String entityPoster = posterPath + bossEntry.name.replace(":", "/") + "/" + bossEntry.name.split(":")[1] + prefixImage;
        ResourceLocation entityCardTexture = ResourceLocation.fromNamespaceAndPath((String)"pladailyboss", (String)entityPoster);
        if (!this.textureExists(entityCardTexture)) {
            entityCardTexture = ResourceLocation.fromNamespaceAndPath((String)"pladailyboss", (String)("textures/gui/entity_posters/not_found/not_found" + prefixImage));
        }
        int imagePadding = 5;
        guiGraphics.blit(entityCardTexture, x + imagePadding, y + imagePadding, 0.0f, 0.0f, 90 - imagePadding * 2, 120 - imagePadding * 2, 90 - imagePadding * 2, 120 - imagePadding * 2);
        guiGraphics.blit(FRAME, x, y, 0.0f, 0.0f, 90, 120, 90, 120);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int bgLeft = (this.width - 512) / 2;
        int bgTop = (this.height - 320) / 2;
        int bgWidth = 512;
        int bgHeight = 320;
        guiGraphics.blit(BACKGROUND, bgLeft, bgTop, 0.0f, 0.0f, bgWidth, bgHeight, bgWidth, bgHeight);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int titleWidth = 100;
        int titleHeight = 18;
        guiGraphics.blit(TITLE, bgLeft + (512 - titleWidth) / 2, bgTop + 22, 0.0f, 0.0f, titleWidth, titleHeight, titleWidth, titleHeight);
        if (this.entityIdStrings == null) {
            return;
        }
        int usableWidth = 472;
        int maxColumns = usableWidth / 110;
        int totalWidth = maxColumns * 90 + (maxColumns - 1) * 20;
        int startX = bgLeft + (512 - totalWidth) / 2;
        int usableHeight = 310;
        int maxRows = usableHeight / 125;
        int startY = bgTop + 40;
        int entitiesPerPage = maxRows * maxColumns;
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.entityIdStrings.size() / (double)entitiesPerPage));
        this.currentPage = Math.max(1, Math.min(this.currentPage, this.totalPages));
        int startIndex = (this.currentPage - 1) * entitiesPerPage;
        int endIndex = Math.min(startIndex + entitiesPerPage, this.entityIdStrings.size());
        List<BossEntry> entitiesToRender = this.entityIdStrings.subList(startIndex, endIndex);
        for (int i = 0; i < entitiesToRender.size(); ++i) {
            int col = i % maxColumns;
            int row = i / maxColumns;
            int x = startX + col * 110;
            int y = startY + row * 125;
            this.drawEntityCard(guiGraphics, x, y, entitiesToRender.get(i));
        }
    }

    private void handlePrevPage(Button button) {
        if (this.currentPage > 1) {
            --this.currentPage;
        }
        this.pageButton.setMessage((Component)Component.literal((String)(this.currentPage + "/" + this.totalPages)));
    }

    private void handleNextPage(Button button) {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
        }
        this.pageButton.setMessage((Component)Component.literal((String)(this.currentPage + "/" + this.totalPages)));
    }

    private void doNothing(Button button) {
    }

    static {
        TITLE = ResourceLocation.fromNamespaceAndPath((String)"pladailyboss", (String)"textures/gui/element/title.png");
        BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"pladailyboss", (String)"textures/gui/element/screen_background.png");
        FRAME = ResourceLocation.fromNamespaceAndPath((String)"pladailyboss", (String)"textures/gui/element/frame.png");
    }
}

