/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.event;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class RewardEvent {
    public static void dropLoot(ServerLevel level, ResourceLocation lootTableRL, BlockPos pos, int rolls) {
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableRL);
        LootTable table = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
        LootParams.Builder ctxBuilder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos));
        for (int i = 0; i < rolls; ++i) {
            ObjectArrayList items = table.getRandomItems(ctxBuilder.create(LootContextParamSets.CHEST));
            for (ItemStack stack : items) {
                if (stack.isEmpty()) continue;
                ItemEntity entity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, stack.copy());
                entity.setDeltaMovement(RewardEvent.randomVelocity(), 0.4 + level.random.nextDouble() * 0.4, RewardEvent.randomVelocity());
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    private static double randomVelocity() {
        return (Math.random() - 0.5) * 0.6;
    }
}

